/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.LinkType;

public class ChangeModeParams {
    private final Optional<String> mode;
    private final boolean recursive;
    private final Optional<LinkType> linkType;

    public ChangeModeParams(Builder builder) {
        this.mode = Optional.of(builder.mode);
        this.recursive = builder.recursive;
        this.linkType = Optional.ofNullable(builder.linkType);
    }

    public Optional<String> getMode() {
        return this.mode;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Optional<LinkType> getLinkType() {
        return this.linkType;
    }

    public String toString() {
        return "ChangeModeParams{mode=" + this.mode + ", recursive=" + this.recursive + ", linkType=" + this.linkType + "}";
    }

    public static class Builder {
        private String mode;
        private boolean recursive = false;
        private LinkType linkType;

        public ChangeModeParams build() {
            return new ChangeModeParams(this);
        }

        public Builder mode(String mode) {
            ValidateUtils.checkNullParameter(mode == null, "mode is null");
            ValidateUtils.checkIllegalParameter(mode.isEmpty(), "mode not specified");
            this.mode = mode;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder linktype(LinkType type) {
            this.linkType = type;
            return this;
        }
    }
}

