/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import java.util.OptionalInt;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.ListFilterType;

public class ListParams {
    private final Optional<String> path;
    private final OptionalInt maxLength;
    private final Optional<String> group;
    private final Optional<String> user;
    private final Optional<String> mtime;
    private final OptionalInt size;
    private final Optional<String> name;
    private final Optional<String> perm;
    private final Optional<ListFilterType> type;
    private final OptionalInt depth;
    public final boolean filesys;
    public final boolean symlinks;

    public ListParams(Builder builder) {
        this.path = Optional.of(builder.path);
        this.maxLength = builder.maxLength == null ? OptionalInt.empty() : OptionalInt.of(builder.maxLength);
        this.group = Optional.ofNullable(builder.group);
        this.user = Optional.ofNullable(builder.user);
        this.mtime = Optional.ofNullable(builder.mtime);
        this.size = builder.size == null ? OptionalInt.empty() : OptionalInt.of(builder.size);
        this.name = Optional.ofNullable(builder.name);
        this.perm = Optional.ofNullable(builder.perm);
        this.type = Optional.ofNullable(builder.type);
        this.depth = builder.depth == null ? OptionalInt.empty() : OptionalInt.of(builder.depth);
        this.filesys = builder.filesys;
        this.symlinks = builder.symlinks;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public OptionalInt getMaxLength() {
        return this.maxLength;
    }

    public Optional<String> getGroup() {
        return this.group;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public Optional<String> getMtime() {
        return this.mtime;
    }

    public OptionalInt getSize() {
        return this.size;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getPerm() {
        return this.perm;
    }

    public Optional<ListFilterType> getType() {
        return this.type;
    }

    public OptionalInt getDepth() {
        return this.depth;
    }

    public boolean isFilesys() {
        return this.filesys;
    }

    public boolean isSymlinks() {
        return this.symlinks;
    }

    public String toString() {
        return "ListParams{path=" + this.path + ", maxLength=" + this.maxLength + ", group=" + this.group + ", user=" + this.user + ", mtime=" + this.mtime + ", size=" + this.size + ", name=" + this.name + ", perm=" + this.perm + ", type=" + this.type + ", depth=" + this.depth + ", filesys=" + this.filesys + ", symlinks=" + this.symlinks + "}";
    }

    public static class Builder {
        private String path;
        private Integer maxLength;
        private String group;
        private String user;
        private String mtime;
        private Integer size;
        private String name;
        private String perm;
        private ListFilterType type;
        private Integer depth;
        private boolean filesys = false;
        private boolean symlinks = false;

        public ListParams build() {
            return new ListParams(this);
        }

        public Builder path(String path) {
            ValidateUtils.checkNullParameter(path == null, "path is null");
            ValidateUtils.checkIllegalParameter(path.isEmpty(), "path not specified");
            this.path = path;
            return this;
        }

        public Builder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder mtime(String mtime) {
            this.mtime = mtime;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder perm(String perm) {
            this.perm = perm;
            return this;
        }

        public Builder type(ListFilterType type) {
            this.type = type;
            return this;
        }

        public Builder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public Builder filesys(boolean filesys) {
            this.filesys = filesys;
            return this;
        }

        public Builder symlinks(boolean symlinks) {
            this.symlinks = symlinks;
            return this;
        }
    }
}

