/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPostRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.CreateParams;

public class UssCreate {
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssCreate(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssCreate(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPostRequest)) {
            throw new Exception("POST_JSON request type required");
        }
        this.request = request;
    }

    public Response create(String name, CreateParams params) throws Exception {
        ValidateUtils.checkNullParameter(name == null, "name is null");
        ValidateUtils.checkIllegalParameter(name.isEmpty(), "name not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + name;
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("type", params.getType().getValue());
        jsonMap.put("mode", params.getMode());
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(jsonMap).toString());
        return RestUtils.getResponse(this.request);
    }
}

