/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.input;

import java.util.Optional;
import java.util.OptionalInt;

public class GetJobParams {
    private final Optional<String> owner;
    private final Optional<String> prefix;
    private final OptionalInt maxJobs;
    private final Optional<String> jobId;

    private GetJobParams(Builder builder) {
        this.owner = Optional.ofNullable(builder.owner);
        this.prefix = Optional.ofNullable(builder.prefix);
        this.maxJobs = builder.maxJobs == null ? OptionalInt.empty() : OptionalInt.of(builder.maxJobs);
        this.jobId = Optional.ofNullable(builder.jobId);
    }

    public Optional<String> getJobId() {
        return this.jobId;
    }

    public OptionalInt getMaxJobs() {
        return this.maxJobs;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Optional<String> getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return "GetJobParams{owner=" + this.owner + ", prefix=" + this.prefix + ", maxJobs=" + this.maxJobs + ", jobId=" + this.jobId + "}";
    }

    public static class Builder {
        private String owner = "*";
        private String prefix = "*";
        private Integer maxJobs = 1000;
        private String jobId;

        public Builder() {
        }

        public Builder(String owner) {
            this.owner = owner;
        }

        public GetJobParams build() {
            return new GetJobParams(this);
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder maxJobs(Integer maxJobs) {
            this.maxJobs = maxJobs;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }
    }
}

