/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.TextGetRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.JobUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.CommonJobParams;
import zowe.client.sdk.zosjobs.input.GetJobParams;
import zowe.client.sdk.zosjobs.input.JobFile;
import zowe.client.sdk.zosjobs.response.Job;

public class JobGet {
    private static final Logger LOG = LoggerFactory.getLogger(JobGet.class);
    private final ZosConnection connection;
    private ZoweRequest request;
    private String url;

    public JobGet(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public JobGet(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public String getJcl(String jobName, String jobId) throws Exception {
        return this.getJclCommon(new CommonJobParams(jobId, jobName));
    }

    public String getJclCommon(CommonJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getJobName().isEmpty(), "jobName not specified");
        ValidateUtils.checkIllegalParameter(params.getJobName().get().isEmpty(), "jobName not specified");
        ValidateUtils.checkIllegalParameter(params.getJobId().isEmpty(), "jobId not specified");
        ValidateUtils.checkIllegalParameter(params.getJobId().get().isEmpty(), "jobId not specified");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files/JCL/records";
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        Response response = RestUtils.getResponse(this.request);
        return (String)response.getResponsePhrase().get();
    }

    public String getJclByJob(Job job) throws Exception {
        return this.getJclCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null)));
    }

    public Job getById(String jobId) throws Exception {
        ValidateUtils.checkNullParameter(jobId == null, "jobId is null");
        ValidateUtils.checkIllegalParameter(jobId.isEmpty(), "jobId not specified");
        List<Job> jobs = this.getCommon(new GetJobParams.Builder("*").jobId(jobId).build());
        if (jobs.isEmpty()) {
            throw new Exception("Job not found");
        }
        if (jobs.size() > 1) {
            throw new Exception("Expected 1 job returned but received " + jobs.size() + " jobs.");
        }
        return jobs.get(0);
    }

    public List<Job> getAll() throws Exception {
        return this.getCommon(null);
    }

    public List<Job> getByOwner(String owner) throws Exception {
        ValidateUtils.checkNullParameter(owner == null, "owner is null");
        ValidateUtils.checkIllegalParameter(owner.isEmpty(), "owner not specified");
        return this.getCommon(new GetJobParams.Builder(owner).build());
    }

    public List<Job> getByOwnerAndPrefix(String owner, String prefix) throws Exception {
        ValidateUtils.checkNullParameter(owner == null, "owner is null");
        ValidateUtils.checkIllegalParameter(owner.isEmpty(), "owner not specified");
        ValidateUtils.checkNullParameter(prefix == null, "prefix is null");
        ValidateUtils.checkIllegalParameter(prefix.isEmpty(), "prefix not specified");
        return this.getCommon(new GetJobParams.Builder(owner).prefix(prefix).build());
    }

    public List<Job> getByPrefix(String prefix) throws Exception {
        ValidateUtils.checkNullParameter(prefix == null, "prefix is null");
        ValidateUtils.checkIllegalParameter(prefix.isEmpty(), "prefix not specified");
        return this.getCommon(new GetJobParams.Builder("*").prefix(prefix).build());
    }

    public List<Job> getCommon(GetJobParams params) throws Exception {
        Response response;
        ArrayList<Job> jobs = new ArrayList<Job>();
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs?";
        if (params != null) {
            if (params.getOwner().isPresent()) {
                this.url = this.url + "owner=" + params.getOwner().get();
            }
            if (params.getPrefix().isPresent() && !"*".equals(params.getPrefix().get())) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "prefix=" + EncodeUtils.encodeURIComponent(params.getPrefix().get());
            }
            if (params.getMaxJobs().isPresent() && params.getMaxJobs().getAsInt() != 1000) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "max-jobs=" + params.getMaxJobs().getAsInt();
            }
            if (params.getJobId().isPresent()) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "jobid=" + params.getJobId().get();
            }
        } else {
            this.url = this.url + "owner=" + this.connection.getUser();
        }
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        try {
            response = RestUtils.getResponse(this.request);
        }
        catch (Exception e) {
            LOG.debug("JobGet::getJobsCommon - {}", (Object)e.getMessage());
            if (e.getMessage().contains("no response phrase returned")) {
                return jobs;
            }
            throw e;
        }
        JSONArray results = (JSONArray)new JSONParser().parse(response.getResponsePhrase().get().toString());
        results.forEach(item -> {
            JSONObject jobObj = (JSONObject)item;
            jobs.add(JobUtils.parseJsonJobResponse(jobObj));
        });
        return jobs;
    }

    public String getSpoolContent(JobFile jobFile) throws Exception {
        return this.getSpoolContentCommon(jobFile);
    }

    public String getSpoolContent(String jobName, String jobId, int spoolId) throws Exception {
        ValidateUtils.checkNullParameter(jobName == null, "jobName is null");
        ValidateUtils.checkNullParameter(jobId == null, "jobId is null");
        ValidateUtils.checkIllegalParameter(spoolId <= 0, "spoolId not specified");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(jobName) + "/" + jobId + "/files/" + spoolId + "/records";
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        Response response = RestUtils.getResponse(this.request);
        return (String)response.getResponsePhrase().get();
    }

    public String getSpoolContentCommon(JobFile jobFile) throws Exception {
        ValidateUtils.checkNullParameter(jobFile == null, "jobFile is null");
        ValidateUtils.checkIllegalParameter(jobFile.getJobName().isEmpty(), "jobName not specified");
        ValidateUtils.checkIllegalParameter(jobFile.getJobId().isEmpty(), "jobId not specified");
        ValidateUtils.checkIllegalParameter(jobFile.getId().isEmpty(), "id not specified");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(jobFile.getJobName().get()) + "/" + jobFile.getJobId().get() + "/files/" + jobFile.getId().get() + "/records";
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        Response response = RestUtils.getResponse(this.request);
        return (String)response.getResponsePhrase().get();
    }

    public List<JobFile> getSpoolFiles(String jobName, String jobId) throws Exception {
        return this.getSpoolFilesCommon(new CommonJobParams(jobId, jobName));
    }

    public List<JobFile> getSpoolFilesCommon(CommonJobParams params) throws Exception {
        Response response;
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getJobId().isEmpty(), "jobId not specified");
        ValidateUtils.checkIllegalParameter(params.getJobId().get().isEmpty(), "jobId not specified");
        ValidateUtils.checkIllegalParameter(params.getJobName().isEmpty(), "jobName not specified");
        ValidateUtils.checkIllegalParameter(params.getJobName().get().isEmpty(), "jobName not specified");
        ArrayList<JobFile> files = new ArrayList<JobFile>();
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files";
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        try {
            response = RestUtils.getResponse(this.request);
        }
        catch (Exception e) {
            LOG.debug("JobGet::getSpoolFilesCommon - {}", (Object)e.getMessage());
            if (e.getMessage().contains("no response phrase returned")) {
                return files;
            }
            throw e;
        }
        JSONArray results = (JSONArray)new JSONParser().parse(response.getResponsePhrase().get().toString());
        results.forEach(item -> {
            JSONObject fileObj = (JSONObject)item;
            files.add(new JobFile.Builder().jobId((String)fileObj.get("jobid")).jobName((String)fileObj.get("jobname")).recfm((String)fileObj.get("recfm")).byteCount((Long)fileObj.get("byteCount")).recordCount((Long)fileObj.get("recordCount")).jobCorrelator((String)fileObj.get("job-correlator")).classs((String)fileObj.get("class")).id((Long)fileObj.get("id")).ddName((String)fileObj.get("ddname")).recordsUrl((String)fileObj.get("records-url")).lrecl((Long)fileObj.get("lrecl")).subSystem((String)fileObj.get("subsystem")).stepName((String)fileObj.get("stepname")).procStep((String)fileObj.get("procstep")).build());
        });
        return files;
    }

    public List<JobFile> getSpoolFilesByJob(Job job) throws Exception {
        return this.getSpoolFilesCommon(new CommonJobParams(job.getJobId().orElseThrow(() -> new Exception("job id not specified")), job.getJobName().orElseThrow(() -> new Exception("job name not specified"))));
    }

    public Job getStatus(String jobName, String jobId) throws Exception {
        ValidateUtils.checkNullParameter(jobName == null, "jobName is null");
        ValidateUtils.checkNullParameter(jobId == null, "jobId is null");
        return this.getStatusCommon(new CommonJobParams(jobId, jobName, true));
    }

    public Job getStatusCommon(CommonJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getJobId().isEmpty(), "jobId not specified");
        ValidateUtils.checkIllegalParameter(params.getJobId().get().isEmpty(), "jobId not specified");
        ValidateUtils.checkIllegalParameter(params.getJobName().isEmpty(), "jobName not specified");
        ValidateUtils.checkIllegalParameter(params.getJobName().get().isEmpty(), "jobName not specified");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get();
        if (params.isStepData().booleanValue()) {
            this.url = this.url + "?step-data=Y";
        }
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        Response response = RestUtils.getResponse(this.request);
        return JobUtils.parseJsonJobResponse((JSONObject)new JSONParser().parse(response.getResponsePhrase().get().toString()));
    }

    public Job getStatusByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getStatusCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null), true));
    }

    public String getStatusValue(String jobName, String jobId) throws Exception {
        ValidateUtils.checkNullParameter(jobName == null, "jobName is null");
        ValidateUtils.checkNullParameter(jobId == null, "jobId is null");
        Job job = this.getStatusCommon(new CommonJobParams(jobId, jobName));
        return job.getStatus().orElseThrow(() -> new Exception("job status is missing"));
    }

    public String getStatusValueByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        Job result = this.getStatusCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null)));
        return result.getStatus().orElseThrow(() -> new Exception("job status is missing"));
    }

    public String getUrl() {
        return this.url;
    }
}

