/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.lifecycle;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonDeleteRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.TsoUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.StopTsoParams;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.StartStopResponse;

public class StopTso {
    private static final Logger LOG = LoggerFactory.getLogger(StopTso.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public StopTso(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public StopTso(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonDeleteRequest)) {
            throw new Exception("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public StartStopResponse stop(String servletKey) throws Exception {
        ValidateUtils.checkNullParameter(servletKey == null, "servletKey is null");
        ValidateUtils.checkIllegalParameter(servletKey.isBlank(), "servletKey not specified");
        StopTsoParams commandParams = new StopTsoParams(servletKey);
        ZosmfTsoResponse zosmfResponse = this.stopCommon(commandParams);
        return TsoUtils.populateStartAndStop(zosmfResponse);
    }

    public ZosmfTsoResponse stopCommon(StopTsoParams commandParams) throws Exception {
        ValidateUtils.checkNullParameter(commandParams == null, "commandParams is null");
        ValidateUtils.checkIllegalParameter(commandParams.getServletKey().isEmpty(), "servletKey not specified");
        ValidateUtils.checkIllegalParameter(commandParams.getServletKey().get().isBlank(), "servletKey not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/tsoApp/tso/" + commandParams.getServletKey().get();
        LOG.debug("StopTso::stopCommon url {}", (Object)url);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        Response response = RestUtils.getResponse(this.request);
        return TsoUtils.parseJsonStopResponse((JSONObject)new JSONParser().parse(response.getResponsePhrase().get().toString()));
    }
}

