/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.utility.ValidateUtils;

public final class EncodeUtils {
    private EncodeUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String encodeURIComponent(String value) {
        ValidateUtils.checkNullParameter(value == null, "str is null");
        ValidateUtils.checkIllegalParameter(value.trim().isEmpty(), "str not specified");
        return URLEncoder.encode(value, StandardCharsets.UTF_8).replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
    }

    public static String getAuthEncoding(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        return Base64.getEncoder().encodeToString((connection.getUser() + ":" + connection.getPassword()).getBytes(StandardCharsets.UTF_8));
    }
}

