/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.ModifyJobParams;
import zowe.client.sdk.zosjobs.response.Job;
import zowe.client.sdk.zosjobs.response.JobStepData;

public final class JobUtils {
    private JobUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void checkModifyJobParameters(ModifyJobParams params) {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getJobId().isEmpty(), "job id not specified");
        ValidateUtils.checkIllegalParameter(params.getJobId().get().trim().isEmpty(), "job id not specified");
        ValidateUtils.checkIllegalParameter(params.getJobName().isEmpty(), "job name not specified");
        ValidateUtils.checkIllegalParameter(params.getJobName().get().trim().isEmpty(), "job name not specified");
    }

    public static Job parseJsonJobResponse(JSONObject jsonObject) {
        ValidateUtils.checkNullParameter(jsonObject == null, "json is null");
        Job.Builder job = new Job.Builder().jobId((String)jsonObject.get("jobid")).jobName((String)jsonObject.get("jobname")).subSystem((String)jsonObject.get("subsystem")).owner((String)jsonObject.get("owner")).type((String)jsonObject.get("type")).status((String)jsonObject.get("status")).url((String)jsonObject.get("url")).classs((String)jsonObject.get("class")).filesUrl((String)jsonObject.get("files-url")).retCode((String)jsonObject.get("retcode")).jobCorrelator((String)jsonObject.get("job-correlator")).phase((Long)jsonObject.get("phase")).phaseName((String)jsonObject.get("phase-name"));
        JSONArray stepData = (JSONArray)jsonObject.get("step-data");
        if (stepData != null) {
            int size = stepData.size();
            JobStepData[] jobStepDataArray = new JobStepData[size];
            for (int i = 0; i < size; ++i) {
                jobStepDataArray[i] = JobUtils.parseJsonJobStepDataResponse((JSONObject)stepData.get(i));
            }
            return job.stepData(jobStepDataArray).build();
        }
        return job.build();
    }

    private static JobStepData parseJsonJobStepDataResponse(JSONObject jsonObject) {
        return new JobStepData.Builder().smfid((String)jsonObject.get("smfid")).completion((String)jsonObject.get("completion")).stepNumber((Long)jsonObject.get("step-number")).programName((String)jsonObject.get("program-name")).active((boolean)((Boolean)jsonObject.get("active"))).stepName((String)jsonObject.get("step-name")).procStepName((String)jsonObject.get("proc-step-name")).build();
    }
}

