/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;

public final class RestUtils {
    private RestUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Response getResponse(ZoweRequest request) throws Exception {
        Response response = request.executeRequest();
        int statusCode = response.getStatusCode().orElseThrow(() -> new Exception("no response status code returned"));
        String responsePhrase = String.valueOf(response.getResponsePhrase().orElse("n/a"));
        if (RestUtils.isHttpError(statusCode)) {
            String statusText = response.getStatusText().orElseThrow(() -> new Exception("no response status text returned"));
            String msg = "http status error code: " + statusCode + ", status text: " + statusText;
            if (!statusText.equalsIgnoreCase(responsePhrase)) {
                msg = msg + ", response phrase: " + responsePhrase;
            }
            throw new Exception(msg);
        }
        return response;
    }

    public static boolean isHttpError(int statusCode) {
        return !(statusCode >= 200 && statusCode <= 299 || statusCode >= 100 && statusCode <= 199);
    }

    public static boolean isUrlNotValid(String url) {
        try {
            new URL(url).toURI();
            return false;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return true;
        }
    }
}

