/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.message.TsoMessage;
import zowe.client.sdk.zostso.message.TsoMessages;
import zowe.client.sdk.zostso.message.TsoPromptMessage;
import zowe.client.sdk.zostso.message.ZosmfMessages;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.StartStopResponse;

public final class TsoUtils {
    private TsoUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static ZosmfTsoResponse getZosmfTsoResponse(Response response) throws Exception {
        ZosmfTsoResponse result;
        ValidateUtils.checkNullParameter(response == null, "response is null");
        int statusCode = response.getStatusCode().get();
        if (response.getStatusCode().isPresent() && RestUtils.isHttpError(statusCode)) {
            ZosmfMessages zosmfMsg = new ZosmfMessages((String)response.getResponsePhrase().orElseThrow(() -> new Exception("no response phrase")), null, null);
            ArrayList<ZosmfMessages> zosmfMessages = new ArrayList<ZosmfMessages>();
            zosmfMessages.add(zosmfMsg);
            result = new ZosmfTsoResponse.Builder().msgData(zosmfMessages).build();
        } else {
            result = TsoUtils.parseJsonTsoResponse((JSONObject)new JSONParser().parse(response.getResponsePhrase().orElseThrow(() -> new Exception("no response phrase")).toString()));
        }
        return result;
    }

    public static ZosmfTsoResponse parseJsonStopResponse(JSONObject obj) {
        ValidateUtils.checkNullParameter(obj == null, "no obj to parse");
        return new ZosmfTsoResponse.Builder().ver((String)obj.get("ver")).servletKey((String)obj.get("servletKey")).reused((Boolean)obj.get("reused")).timeout((Boolean)obj.get("timeout")).build();
    }

    private static void parseJsonTsoMessage(List<TsoMessages> tsoMessagesLst, JSONObject obj, TsoMessages tsoMessages) {
        Map tsoMessageMap = (Map)obj.get("TSO MESSAGE");
        if (tsoMessageMap != null) {
            TsoMessage tsoMessage = new TsoMessage();
            tsoMessageMap.forEach((key, value) -> {
                if ("DATA".equals(key)) {
                    tsoMessage.setData((String)value);
                }
                if ("VERSION".equals(key)) {
                    tsoMessage.setVersion((String)value);
                }
            });
            tsoMessages.setTsoMessage(tsoMessage);
            tsoMessagesLst.add(tsoMessages);
        }
    }

    private static void parseJsonTsoPrompt(List<TsoMessages> tsoMessagesLst, JSONObject obj, TsoMessages tsoMessages) {
        Map tsoPromptMap = (Map)obj.get("TSO PROMPT");
        if (tsoPromptMap != null) {
            TsoPromptMessage tsoPromptMessage = new TsoPromptMessage();
            tsoPromptMap.forEach((key, value) -> {
                if ("VERSION".equals(key)) {
                    tsoPromptMessage.setVersion((String)value);
                }
                if ("HIDDEN".equals(key)) {
                    tsoPromptMessage.setHidden((String)value);
                }
            });
            tsoMessages.setTsoPrompt(tsoPromptMessage);
            tsoMessagesLst.add(tsoMessages);
        }
    }

    private static ZosmfTsoResponse parseJsonTsoResponse(JSONObject result) throws Exception {
        ZosmfTsoResponse response;
        ValidateUtils.checkNullParameter(result == null, "no results to parse");
        try {
            response = new ZosmfTsoResponse.Builder().queueId((String)result.get("queueID")).ver((String)result.get("ver")).servletKey((String)result.get("servletKey")).reused((Boolean)result.get("reused")).timeout((Boolean)result.get("timeout")).build();
        }
        catch (Exception e) {
            throw new Exception("missing one of the following json field values: queueID, ver, servletKey, reused and timeout");
        }
        ArrayList tsoMessagesLst = new ArrayList();
        Optional<JSONArray> tsoData = Optional.ofNullable((JSONArray)result.get("tsoData"));
        tsoData.ifPresent(data -> {
            data.forEach(item -> {
                JSONObject obj = (JSONObject)item;
                TsoMessages tsoMessages = new TsoMessages();
                TsoUtils.parseJsonTsoMessage(tsoMessagesLst, obj, tsoMessages);
                TsoUtils.parseJsonTsoPrompt(tsoMessagesLst, obj, tsoMessages);
            });
            response.setTsoData(tsoMessagesLst);
        });
        return response;
    }

    public static StartStopResponse populateStartAndStop(ZosmfTsoResponse zosmfResponse) {
        ValidateUtils.checkNullParameter(zosmfResponse == null, "zosmfResponse is null");
        StartStopResponse startStopResponse = new StartStopResponse(false, zosmfResponse, zosmfResponse.getServletKey().orElse(""));
        startStopResponse.setSuccess(zosmfResponse.getServletKey().isPresent());
        if (!zosmfResponse.getMsgData().isEmpty()) {
            ZosmfMessages zosmfMsg = zosmfResponse.getMsgData().get(0);
            String msgText = zosmfMsg.getMessageText().orElse("zOSMF unknown error response");
            startStopResponse.setFailureResponse(msgText);
        }
        return startStopResponse;
    }
}

