/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.DataSetUtils;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.ListParams;
import zowe.client.sdk.zosfiles.dsn.response.Dataset;
import zowe.client.sdk.zosfiles.dsn.response.Member;
import zowe.client.sdk.zosfiles.dsn.types.AttributeType;

public class DsnList {
    private static final Logger LOG = LoggerFactory.getLogger(DsnList.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public DsnList(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public DsnList(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonGetRequest)) {
            throw new Exception("GET_JSON request type required");
        }
        this.request = request;
    }

    private Response getResponse(ListParams params, Map<String, String> headers, String url) throws Exception {
        this.setHeaders(params, headers);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(url);
        this.request.setHeaders(headers);
        return this.request.executeRequest();
    }

    private <T> List<T> getResult(Response response, List<T> datasetLst, List<T> memberLst) throws Exception {
        if (response.getStatusCode().isEmpty()) {
            LOG.debug("DsnList::getResult - no status code returned");
            if (datasetLst == null) {
                return memberLst;
            }
            return datasetLst;
        }
        if (response.getResponsePhrase().isEmpty()) {
            LOG.debug("DsnList::getResult - no response phrase returned");
            if (datasetLst == null) {
                return memberLst;
            }
            return datasetLst;
        }
        if (RestUtils.isHttpError(response.getStatusCode().get())) {
            if (response.getStatusText().isEmpty()) {
                LOG.debug("DsnList::getResult - no status text returned");
                if (datasetLst == null) {
                    return memberLst;
                }
                return datasetLst;
            }
            LOG.debug("Rest status code {}", (Object)response.getStatusCode().get());
            LOG.debug("Rest status text {}", (Object)response.getStatusText().get());
            throw new Exception(response.getStatusCode().get() + " - " + response.getResponsePhrase().get());
        }
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(response.getResponsePhrase().get().toString());
        if (jsonObject.isEmpty()) {
            if (datasetLst == null) {
                return memberLst;
            }
            return datasetLst;
        }
        JSONArray items = (JSONArray)jsonObject.get("items");
        items.forEach(item -> {
            JSONObject obj = (JSONObject)item;
            if (datasetLst == null) {
                memberLst.add(DataSetUtils.parseJsonMemberResponse(obj));
            } else {
                datasetLst.add(DataSetUtils.parseJsonDSResponse(obj));
            }
        });
        if (datasetLst == null) {
            return memberLst;
        }
        return datasetLst;
    }

    public List<Dataset> listDsn(String dataSetName, ListParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.trim().isEmpty(), "dataSetName not specified");
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList datasets = new ArrayList();
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds?dslevel=" + EncodeUtils.encodeURIComponent(dataSetName);
        if (params.getVolume().isPresent()) {
            url = url + "&volser=" + EncodeUtils.encodeURIComponent(params.getVolume().get());
        }
        if (params.getStart().isPresent()) {
            url = url + "&start=" + params.getStart().get();
        }
        return this.getResult(this.getResponse(params, headers, url), datasets, null);
    }

    public List<Member> listDsnMembers(String dataSetName, ListParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.trim().isEmpty(), "dataSetName not specified");
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList members = new ArrayList();
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + EncodeUtils.encodeURIComponent(dataSetName) + "/member";
        if (params.getPattern().isPresent()) {
            url = url + "?pattern=" + EncodeUtils.encodeURIComponent(params.getPattern().get());
        }
        return this.getResult(this.getResponse(params, headers, url), null, members);
    }

    private void setHeaders(ListParams params, Map<String, String> headers) {
        String key = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(0);
        String value = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(1);
        headers.put(key, value);
        if (params.getAttribute().isPresent()) {
            AttributeType attribute = params.getAttribute().get();
            if (attribute == AttributeType.BASE) {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(0);
                value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(1);
            } else if (attribute == AttributeType.VOL) {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_VOL").get(0);
                value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_VOL").get(1);
            }
            headers.put(key, value);
        }
        if (params.getMaxLength().isPresent()) {
            key = "X-IBM-Max-Items";
            value = params.getMaxLength().get();
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MAX_ITEMS").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MAX_ITEMS").get(1);
        }
        headers.put(key, value);
        if (params.getResponseTimeout().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RESPONSE_TIMEOUT").get(0);
            value = params.getResponseTimeout().get();
            headers.put(key, value);
        }
        if (params.getRecall().isPresent()) {
            switch (params.getRecall().get().toLowerCase(Locale.ROOT)) {
                case "wait": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_WAIT").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_WAIT").get(1);
                    headers.put(key, value);
                    break;
                }
                case "nowait": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_NO_WAIT").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_NO_WAIT").get(1);
                    headers.put(key, value);
                    break;
                }
                case "error": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_ERROR").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_ERROR").get(1);
                    headers.put(key, value);
                }
            }
        }
    }
}

