/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnRename {
    private final ZosConnection connection;
    private ZoweRequest request;
    private String url;

    public DsnRename(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public DsnRename(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new Exception("PUT_JSON request type required");
        }
    }

    public Response dataSetName(String source, String destination) throws Exception {
        this.setUrl(destination);
        return this.executeRequest(this.buildBody(source));
    }

    public Response memberName(String dsName, String source, String destination) throws Exception {
        this.setUrl(dsName, destination);
        return this.executeRequest(this.buildBody(dsName, source));
    }

    private void setUrl(String ... args) {
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + EncodeUtils.encodeURIComponent(args[0]);
        if (args.length > 1) {
            this.url = this.url + "(" + EncodeUtils.encodeURIComponent(args[1]) + ")";
        }
    }

    private Response executeRequest(String body) throws Exception {
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(this.url);
        this.request.setBody(body);
        return RestUtils.getResponse(this.request);
    }

    private String buildBody(String ... args) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("request", "rename");
        HashMap<String, String> fromDataSetReq = new HashMap<String, String>();
        fromDataSetReq.put("dsn", args[0]);
        if (args.length > 1) {
            fromDataSetReq.put("member", args[1]);
        }
        JSONObject fromDataSetObj = new JSONObject(fromDataSetReq);
        jsonMap.put("from-dataset", fromDataSetObj);
        return new JSONObject(jsonMap).toString();
    }
}

