/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.LinkType;

public class ChangeOwnerParams {
    private final Optional<String> owner;
    private final Optional<String> group;
    private final boolean recursive;
    private final Optional<LinkType> linkType;

    public ChangeOwnerParams(Builder builder) {
        this.owner = Optional.ofNullable(builder.owner);
        this.group = Optional.ofNullable(builder.group);
        this.recursive = builder.recursive;
        this.linkType = Optional.ofNullable(builder.linkType);
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Optional<String> getGroup() {
        return this.group;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Optional<LinkType> getLinkType() {
        return this.linkType;
    }

    public String toString() {
        return "ChangeOwnerParams{owner='" + this.owner + "', group=" + this.group + ", recursive=" + this.recursive + ", linkType=" + this.linkType + "}";
    }

    public static class Builder {
        private String owner;
        private String group;
        private boolean recursive = false;
        private LinkType linkType;

        public ChangeOwnerParams build() {
            return new ChangeOwnerParams(this);
        }

        public Builder owner(String owner) {
            ValidateUtils.checkNullParameter(owner == null, "owner is null");
            ValidateUtils.checkIllegalParameter(owner.trim().isEmpty(), "owner not specified");
            this.owner = owner;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder linktype(LinkType type) {
            this.linkType = type;
            return this;
        }
    }
}

