/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.Map;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonDeleteRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class UssDelete {
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssDelete(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssDelete(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonDeleteRequest)) {
            throw new Exception("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public Response delete(String targetPath) throws Exception {
        return this.delete(targetPath, false);
    }

    public Response delete(String targetPath, boolean recursive) throws Exception {
        ValidateUtils.checkNullParameter(targetPath == null, "targetPath is null");
        ValidateUtils.checkIllegalParameter(targetPath.trim().isEmpty(), "targetPath not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        if (recursive) {
            this.request.setHeaders(Map.of("X-IBM-Option", "recursive"));
        }
        return RestUtils.getResponse(this.request);
    }

    public Response zfsDelete(String fileSystemName) throws Exception {
        ValidateUtils.checkNullParameter(fileSystemName == null, "file system name is null");
        ValidateUtils.checkIllegalParameter(fileSystemName.trim().isEmpty(), "file system name not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/mfs/zfs/" + EncodeUtils.encodeURIComponent(fileSystemName);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        return RestUtils.getResponse(this.request);
    }
}

