/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.response;

import java.util.Optional;
import java.util.OptionalLong;

public class UssItem {
    private final Optional<String> name;
    private final Optional<String> mode;
    private final OptionalLong size;
    private final OptionalLong uid;
    private final Optional<String> user;
    private final OptionalLong gid;
    private final Optional<String> group;
    private final Optional<String> mtime;

    public UssItem(Builder builder) {
        this.name = Optional.ofNullable(builder.name);
        this.mode = Optional.ofNullable(builder.mode);
        this.size = builder.size == null ? OptionalLong.empty() : OptionalLong.of(builder.size);
        this.uid = builder.uid == null ? OptionalLong.empty() : OptionalLong.of(builder.uid);
        this.user = Optional.ofNullable(builder.user);
        this.gid = builder.gid == null ? OptionalLong.empty() : OptionalLong.of(builder.gid);
        this.group = Optional.ofNullable(builder.group);
        this.mtime = Optional.ofNullable(builder.mtime);
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getMode() {
        return this.mode;
    }

    public OptionalLong getSize() {
        return this.size;
    }

    public OptionalLong getUid() {
        return this.uid;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public OptionalLong getGid() {
        return this.gid;
    }

    public Optional<String> getGroup() {
        return this.group;
    }

    public Optional<String> getMtime() {
        return this.mtime;
    }

    public String toString() {
        return "UssItem{name=" + this.name + ", mode=" + this.mode + ", size=" + this.size + ", uid=" + this.uid + ", user=" + this.user + ", gid=" + this.gid + ", group=" + this.group + ", mtime=" + this.mtime + "}";
    }

    public static class Builder {
        private String name;
        private String mode;
        private Long size;
        private Long uid;
        private String user;
        private Long gid;
        private String group;
        private String mtime;

        public UssItem build() {
            return new UssItem(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder uid(Long uid) {
            this.uid = uid;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder gid(Long gid) {
            this.gid = gid;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder mtime(String mtime) {
            this.mtime = mtime;
            return this;
        }
    }
}

