/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.response;

import java.util.Optional;
import java.util.OptionalLong;

public class UssZfsItem {
    private final Optional<String> name;
    private final Optional<String> mountpoint;
    private final Optional<String> fstname;
    private final Optional<String> status;
    private final Optional<String> mode;
    private final OptionalLong dev;
    private final OptionalLong fstype;
    private final OptionalLong bsize;
    private final OptionalLong bavail;
    private final OptionalLong blocks;
    private final Optional<String> sysname;
    public final OptionalLong readibc;
    public final OptionalLong writeibc;
    private final OptionalLong diribc;
    private final OptionalLong returnedRows;
    private final OptionalLong totalRows;
    private final boolean moreRows;

    public UssZfsItem(Builder builder) {
        this.name = Optional.ofNullable(builder.name);
        this.mountpoint = Optional.ofNullable(builder.mountpoint);
        this.fstname = Optional.ofNullable(builder.fstname);
        this.status = Optional.ofNullable(builder.status);
        this.mode = Optional.ofNullable(builder.mode);
        this.dev = builder.dev == null ? OptionalLong.empty() : OptionalLong.of(builder.dev);
        this.fstype = builder.fstype == null ? OptionalLong.empty() : OptionalLong.of(builder.fstype);
        this.bsize = builder.bsize == null ? OptionalLong.empty() : OptionalLong.of(builder.bsize);
        this.bavail = builder.bavail == null ? OptionalLong.empty() : OptionalLong.of(builder.bavail);
        this.blocks = builder.blocks == null ? OptionalLong.empty() : OptionalLong.of(builder.blocks);
        this.sysname = Optional.ofNullable(builder.sysname);
        this.readibc = builder.readibc == null ? OptionalLong.empty() : OptionalLong.of(builder.readibc);
        this.writeibc = builder.writeibc == null ? OptionalLong.empty() : OptionalLong.of(builder.writeibc);
        this.diribc = builder.diribc == null ? OptionalLong.empty() : OptionalLong.of(builder.diribc);
        this.returnedRows = builder.returnedRows == null ? OptionalLong.empty() : OptionalLong.of(builder.returnedRows);
        this.totalRows = builder.totalRows == null ? OptionalLong.empty() : OptionalLong.of(builder.totalRows);
        this.moreRows = builder.moreRows;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getMountpoint() {
        return this.mountpoint;
    }

    public Optional<String> getFstname() {
        return this.fstname;
    }

    public Optional<String> getStatus() {
        return this.status;
    }

    public Optional<String> getMode() {
        return this.mode;
    }

    public OptionalLong getDev() {
        return this.dev;
    }

    public OptionalLong getFstype() {
        return this.fstype;
    }

    public OptionalLong getBsize() {
        return this.bsize;
    }

    public OptionalLong getBavail() {
        return this.bavail;
    }

    public OptionalLong getBlocks() {
        return this.blocks;
    }

    public Optional<String> getSysname() {
        return this.sysname;
    }

    public OptionalLong getReadibc() {
        return this.readibc;
    }

    public OptionalLong getWriteibc() {
        return this.writeibc;
    }

    public OptionalLong getDiribc() {
        return this.diribc;
    }

    public OptionalLong getReturnedRows() {
        return this.returnedRows;
    }

    public OptionalLong getTotalRows() {
        return this.totalRows;
    }

    public boolean isMoreRows() {
        return this.moreRows;
    }

    public String toString() {
        return "UssZfsItem{name=" + this.name + ", mountpoint=" + this.mountpoint + ", fstname=" + this.fstname + ", status=" + this.status + ", mode=" + this.mode + ", dev=" + this.dev + ", fstype=" + this.fstype + ", bsize=" + this.bsize + ", bavail=" + this.bavail + ", blocks=" + this.blocks + ", sysname=" + this.sysname + ", readibc=" + this.readibc + ", writeibc=" + this.writeibc + ", diribc=" + this.diribc + ", returnedRows=" + this.returnedRows + ", totalRows=" + this.totalRows + ", moreRows=" + this.moreRows + "}";
    }

    public static class Builder {
        private String name;
        private String mountpoint;
        private String fstname;
        private String status;
        private String mode;
        private Long dev;
        private Long fstype;
        private Long bsize;
        private Long bavail;
        private Long blocks;
        private String sysname;
        private Long readibc;
        private Long writeibc;
        private Long diribc;
        private Long returnedRows;
        private Long totalRows;
        private boolean moreRows = false;

        public UssZfsItem build() {
            return new UssZfsItem(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mountpoint(String mountpoint) {
            this.mountpoint = mountpoint;
            return this;
        }

        public Builder fstname(String fstname) {
            this.fstname = fstname;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder dev(Long dev) {
            this.dev = dev;
            return this;
        }

        public Builder fstype(Long fstype) {
            this.fstype = fstype;
            return this;
        }

        public Builder bsize(Long bsize) {
            this.bsize = bsize;
            return this;
        }

        public Builder bavail(Long bavail) {
            this.bavail = bavail;
            return this;
        }

        public Builder blocks(Long blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder sysname(String sysname) {
            this.sysname = sysname;
            return this;
        }

        public Builder readibc(Long readibc) {
            this.readibc = readibc;
            return this;
        }

        public Builder writeibc(Long writeibc) {
            this.writeibc = writeibc;
            return this;
        }

        public Builder diribc(Long diribc) {
            this.diribc = diribc;
            return this;
        }

        public Builder returnedRows(Long returnedRows) {
            this.returnedRows = returnedRows;
            return this;
        }

        public Builder totalRows(Long totalRows) {
            this.totalRows = totalRows;
            return this;
        }

        public Builder moreRows(boolean moreRows) {
            this.moreRows = moreRows;
            return this;
        }
    }
}

