/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.response;

import java.util.List;
import java.util.Optional;
import zowe.client.sdk.zostso.message.TsoMessages;
import zowe.client.sdk.zostso.message.ZosmfMessages;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.CollectedResponses;

public class StartStopResponses {
    private final ZosmfTsoResponse zosmfTsoResponse;
    private final String failureResponse;
    private final String messages;
    private final boolean success;
    private List<ZosmfTsoResponse> collectedResponses;
    private String servletKey;

    public StartStopResponses(ZosmfTsoResponse zosmfTsoResponse, CollectedResponses collectedResponses) throws Exception {
        if (zosmfTsoResponse == null) {
            throw new Exception("zosmfTsoResponse is null");
        }
        this.zosmfTsoResponse = zosmfTsoResponse;
        if (!zosmfTsoResponse.getMsgData().isEmpty()) {
            this.success = false;
            ZosmfMessages zosmfMsg = zosmfTsoResponse.getMsgData().get(0);
            this.failureResponse = zosmfMsg.getMessageText().orElse("zOSMF unknown error response");
        } else {
            this.success = true;
            this.failureResponse = null;
        }
        this.servletKey = zosmfTsoResponse.getServletKey().orElseThrow(() -> new Exception("servletKey is missing"));
        StringBuilder buildMessage = new StringBuilder();
        List<TsoMessages> tsoMsgLst = zosmfTsoResponse.getTsoData();
        tsoMsgLst.forEach(buildMessage::append);
        this.messages = buildMessage.toString();
        this.collectedResponses = collectedResponses.getTsos();
    }

    public List<ZosmfTsoResponse> getCollectedResponses() {
        return this.collectedResponses;
    }

    public void setCollectedResponses(List<ZosmfTsoResponse> collectedResponses) {
        this.collectedResponses = collectedResponses;
    }

    public Optional<String> getFailureResponse() {
        return Optional.of(this.failureResponse);
    }

    public Optional<String> getMessages() {
        return Optional.of(this.messages);
    }

    public Optional<String> getServletKey() {
        return Optional.ofNullable(this.servletKey);
    }

    public void setServletKey(String servletKey) {
        this.servletKey = servletKey;
    }

    public Optional<ZosmfTsoResponse> getZosmfTsoResponse() {
        return Optional.of(this.zosmfTsoResponse);
    }

    public boolean isSuccess() {
        return this.success;
    }
}

