/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import org.json.simple.JSONObject;
import zowe.client.sdk.parse.DatasetParseResponse;
import zowe.client.sdk.parse.JobFileParseResponse;
import zowe.client.sdk.parse.JobParseResponse;
import zowe.client.sdk.parse.JsonParseResponse;
import zowe.client.sdk.parse.MemberParseResponse;
import zowe.client.sdk.parse.MvsConsoleParseResponse;
import zowe.client.sdk.parse.PropsParseResponse;
import zowe.client.sdk.parse.SystemInfoParseResponse;
import zowe.client.sdk.parse.SystemsParseResponse;
import zowe.client.sdk.parse.TsoParseResponse;
import zowe.client.sdk.parse.TsoStopParseResponse;
import zowe.client.sdk.parse.UnixFileParseResponse;
import zowe.client.sdk.parse.UnixZfsParseResponse;
import zowe.client.sdk.parse.ZosLogItemParseResponse;
import zowe.client.sdk.parse.ZosLogReplyParseResponse;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.utility.ValidateUtils;

public final class JsonParseResponseFactory {
    private JsonParseResponseFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static JsonParseResponse buildParser(JSONObject data, ParseType type) throws Exception {
        JsonParseResponse parseResponse;
        ValidateUtils.checkNullParameter(data == null, "json data is null");
        switch (type) {
            case DATASET: {
                parseResponse = new DatasetParseResponse(data);
                break;
            }
            case JOB: {
                parseResponse = new JobParseResponse(data);
                break;
            }
            case JOB_FILE: {
                parseResponse = new JobFileParseResponse(data);
                break;
            }
            case MEMBER: {
                parseResponse = new MemberParseResponse(data);
                break;
            }
            case MVS_CONSOLE: {
                parseResponse = new MvsConsoleParseResponse(data);
                break;
            }
            case PROPS: {
                parseResponse = new PropsParseResponse(data);
                break;
            }
            case TSO_CONSOLE: {
                parseResponse = new TsoParseResponse(data);
                break;
            }
            case TSO_STOP: {
                parseResponse = new TsoStopParseResponse(data);
                break;
            }
            case UNIX_FILE: {
                parseResponse = new UnixFileParseResponse(data);
                break;
            }
            case UNIX_ZFS: {
                parseResponse = new UnixZfsParseResponse(data);
                break;
            }
            case ZOS_LOG_ITEM: {
                parseResponse = new ZosLogItemParseResponse(data);
                break;
            }
            case ZOS_LOG_REPLY: {
                parseResponse = new ZosLogReplyParseResponse(data);
                break;
            }
            case ZOSMF_SYSTEMS: {
                parseResponse = new SystemsParseResponse(data);
                break;
            }
            case ZOSMF_INFO: {
                parseResponse = new SystemInfoParseResponse(data);
                break;
            }
            default: {
                throw new Exception("no valid parse type specified");
            }
        }
        return parseResponse;
    }
}

