/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class TextPutRequest
extends ZoweRequest {
    private static final Logger LOG = LoggerFactory.getLogger(TextPutRequest.class);
    private String body;

    public TextPutRequest(ZosConnection connection) {
        super(connection);
    }

    @Override
    public Response executeRequest() throws UnirestException {
        ValidateUtils.checkNullParameter(this.url == null, "url is null");
        ValidateUtils.checkNullParameter(this.body == null, "body is null");
        HttpResponse<String> reply = ((HttpRequestWithBody)Unirest.put(this.url).headers(this.headers)).body(this.body).asString();
        if (reply.getStatusText().contains("No Content")) {
            return new Response(reply.getStatusText(), reply.getStatus(), reply.getStatusText());
        }
        return new Response(reply.getBody(), reply.getStatus(), reply.getStatusText());
    }

    @Override
    public void setBody(Object body) {
        this.body = (String)body;
        LOG.debug(this.body);
    }

    @Override
    public void setStandardHeaders() {
        this.headers.put("Authorization", "Basic " + EncodeUtils.encodeAuthComponent(this.connection));
        this.headers.put("Content-Type", "text/plain; charset=UTF-8");
        this.headers.put(X_CSRF_ZOSMF_HEADER_KEY, X_CSRF_ZOSMF_HEADER_VALUE);
    }
}

