/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;

public final class RestUtils {
    private RestUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Response getResponse(ZoweRequest request) throws Exception {
        Response response = request.executeRequest();
        String statusCodeErrMsg = "no response status code returned";
        int statusCode = response.getStatusCode().orElseThrow(() -> new Exception("no response status code returned"));
        if (RestUtils.isHttpError(statusCode)) {
            AtomicReference<String> responsePhrase = new AtomicReference<String>();
            response.getResponsePhrase().ifPresent(responsePhrase::set);
            if (responsePhrase.get() instanceof byte[]) {
                String line;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])responsePhrase.get()), StandardCharsets.UTF_8);
                BufferedReader br = new BufferedReader(inputStreamReader);
                Object content = "";
                while ((line = br.readLine()) != null) {
                    content = (String)content + line + "\n";
                }
                responsePhrase.set(((String)content).substring(0, ((String)content).length() - 1));
            }
            String responsePhraseStr = String.valueOf(responsePhrase.get());
            String statusText = response.getStatusText().isPresent() ? response.getStatusText().get() : "n\\a";
            String errMsg = "http status error code: " + statusCode + ", status text: " + statusText;
            if (!statusText.equalsIgnoreCase(responsePhraseStr)) {
                errMsg = errMsg + ", response phrase: " + responsePhraseStr;
            }
            throw new Exception(errMsg);
        }
        return response;
    }

    public static boolean isHttpError(int statusCode) {
        return !(statusCode >= 200 && statusCode <= 299 || statusCode >= 100 && statusCode <= 199);
    }

    public static boolean isUrlNotValid(String url) {
        try {
            new URL(url).toURI();
            return false;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return true;
        }
    }
}

