/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosconsole.method;

import java.util.HashMap;
import org.apache.commons.text.StringEscapeUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseResponse;
import zowe.client.sdk.parse.JsonParseResponseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosconsole.input.IssueParams;
import zowe.client.sdk.zosconsole.input.ZosmfIssueParams;
import zowe.client.sdk.zosconsole.response.ConsoleResponse;
import zowe.client.sdk.zosconsole.response.ZosmfIssueResponse;
import zowe.client.sdk.zosconsole.service.ConsoleResponseService;

public class IssueConsole {
    private final ZosConnection connection;
    private ZoweRequest request;

    public IssueConsole(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public IssueConsole(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new Exception("PUT_JSON request type required");
        }
        this.request = request;
    }

    private ZosmfIssueParams buildZosmfConsoleApiParameters(IssueParams params) {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getCommand().isEmpty(), "command not specified");
        ZosmfIssueParams zosmfParams = new ZosmfIssueParams();
        zosmfParams.setCmd(params.getCommand().get());
        params.getSolicitedKeyword().ifPresent(zosmfParams::setSolKey);
        params.getSysplexSystem().ifPresent(zosmfParams::setSystem);
        return zosmfParams;
    }

    public ConsoleResponse issueCommand(IssueParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String consoleName = params.getConsoleName().orElse("defcn");
        ZosmfIssueParams zosmfIssueParams = this.buildZosmfConsoleApiParameters(params);
        ZosmfIssueResponse zosmfIssueResponse = this.issueCommonCommand(consoleName, zosmfIssueParams);
        return new ConsoleResponseService(zosmfIssueResponse).setConsoleResponse(params.getProcessResponses().orElse(true));
    }

    public ZosmfIssueResponse issueCommonCommand(String consoleName, ZosmfIssueParams commandParams) throws Exception {
        ValidateUtils.checkNullParameter(consoleName == null, "consoleName is null");
        ValidateUtils.checkIllegalParameter(consoleName.isBlank(), "consoleName not specified");
        ValidateUtils.checkNullParameter(commandParams == null, "commandParams is null");
        ValidateUtils.checkIllegalParameter(commandParams.getCmd().isEmpty(), "command not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restconsoles/consoles/" + consoleName;
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("cmd", commandParams.getCmd().get());
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(jsonMap).toString());
        String jsonStr = RestUtils.getResponse(this.request).getResponsePhrase().orElseThrow(() -> new Exception("no issue console response phase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        JsonParseResponse parser = JsonParseResponseFactory.buildParser(jsonObject, ParseType.MVS_CONSOLE);
        return (ZosmfIssueResponse)parser.parseResponse();
    }

    public ZosmfIssueResponse issueDefConsoleCommon(ZosmfIssueParams commandParams) throws Exception {
        ZosmfIssueResponse resp = this.issueCommonCommand("defcn", commandParams);
        resp.setCmdResponse(StringEscapeUtils.escapeJava(resp.getCmdResponse().orElse("")));
        return resp;
    }

    public ConsoleResponse issueCommand(String theCommand) throws Exception {
        IssueParams params = new IssueParams();
        params.setCommand(theCommand);
        return this.issueCommand(params);
    }
}

