/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosconsole.service;

import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosconsole.response.ConsoleResponse;
import zowe.client.sdk.zosconsole.response.ZosmfIssueResponse;

public final class ConsoleResponseService {
    private final ZosmfIssueResponse zosmfResponse;

    public ConsoleResponseService(ZosmfIssueResponse zosmfResponse) {
        ValidateUtils.checkNullParameter(zosmfResponse == null, "zosmfResponse is null");
        this.zosmfResponse = zosmfResponse;
    }

    public ConsoleResponse setConsoleResponse(boolean processResponses) {
        ConsoleResponse response = new ConsoleResponse();
        response.setZosmfResponse(this.zosmfResponse);
        response.setSuccess(true);
        if (this.zosmfResponse.getSolKeyDetected().isPresent()) {
            response.setKeywordDetected(true);
        }
        if (this.zosmfResponse.getCmdResponse().isPresent() && this.zosmfResponse.getCmdResponse().get().length() > 0 && processResponses) {
            String responseValue = this.zosmfResponse.getCmdResponse().get().replace('\r', '\n');
            response.setCommandResponse(responseValue);
            if (responseValue.length() > 0 && responseValue.indexOf("\n") != responseValue.length() - 1) {
                response.setCommandResponse(responseValue + "\n");
            }
        }
        this.zosmfResponse.getCmdResponseKey().ifPresent(response::setLastResponseKey);
        this.zosmfResponse.getCmdResponseUrl().ifPresent(response::setCmdResponseUrl);
        return response;
    }
}

