/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnRename {
    private final ZosConnection connection;
    private ZoweRequest request;
    private String url;

    public DsnRename(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public DsnRename(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new Exception("PUT_JSON request type required");
        }
    }

    public Response dataSetName(String dataSetName, String newDataSetName) throws Exception {
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        ValidateUtils.checkNullParameter(newDataSetName == null, "newDataSetName is null");
        ValidateUtils.checkIllegalParameter(newDataSetName.isBlank(), "newDataSetName not specified");
        this.setUrl(newDataSetName);
        return this.executeCommon(dataSetName);
    }

    public Response memberName(String fromDataSetName, String memberName, String newMemberName) throws Exception {
        ValidateUtils.checkNullParameter(fromDataSetName == null, "fromDataSetName is null");
        ValidateUtils.checkIllegalParameter(fromDataSetName.isBlank(), "fromDataSetName not specified");
        ValidateUtils.checkNullParameter(memberName == null, "memberName is null");
        ValidateUtils.checkIllegalParameter(memberName.isBlank(), "memberName not specified");
        ValidateUtils.checkNullParameter(newMemberName == null, "newMemberName is null");
        ValidateUtils.checkIllegalParameter(newMemberName.isBlank(), "newMemberName not specified");
        this.setUrl(fromDataSetName, newMemberName);
        return this.executeCommon(fromDataSetName, memberName);
    }

    private void setUrl(String ... args) {
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + EncodeUtils.encodeURIComponent(args[0]);
        if (args.length > 1) {
            this.url = this.url + "(" + EncodeUtils.encodeURIComponent(args[1]) + ")";
        }
    }

    private Response executeCommon(String ... args) throws Exception {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("request", "rename");
        HashMap<String, String> fromDataSetReq = new HashMap<String, String>();
        fromDataSetReq.put("dsn", args[0]);
        if (args.length > 1) {
            fromDataSetReq.put("member", args[1]);
        }
        JSONObject fromDataSetObj = new JSONObject(fromDataSetReq);
        jsonMap.put("from-dataset", fromDataSetObj);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(this.url);
        this.request.setBody(new JSONObject(jsonMap).toString());
        return RestUtils.getResponse(this.request);
    }
}

