/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import java.util.OptionalInt;
import zowe.client.sdk.utility.ValidateUtils;

public class ListZfsParams {
    private final OptionalInt maxLength;
    private final Optional<String> path;
    private final Optional<String> fsname;

    public ListZfsParams(Builder builder) {
        this.maxLength = builder.maxLength == null ? OptionalInt.empty() : OptionalInt.of(builder.maxLength);
        this.path = Optional.ofNullable(builder.path);
        this.fsname = Optional.ofNullable(builder.fsname);
    }

    public OptionalInt getMaxLength() {
        return this.maxLength;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public Optional<String> getFsname() {
        return this.fsname;
    }

    public String toString() {
        return "ListZfsParams{maxLength=" + this.maxLength + ", path=" + this.path + ", fsname=" + this.fsname + "}";
    }

    public static class Builder {
        private Integer maxLength;
        private String path;
        private String fsname;

        public ListZfsParams build() {
            return new ListZfsParams(this);
        }

        public Builder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder path(String path) throws Exception {
            ValidateUtils.checkNullParameter(path == null, "path is null");
            ValidateUtils.checkIllegalParameter(path.isBlank(), "path not specified");
            if (this.fsname != null) {
                throw new Exception("cannot specify both path and fsname parameters");
            }
            this.path = path;
            return this;
        }

        public Builder fsname(String fsname) throws Exception {
            ValidateUtils.checkNullParameter(fsname == null, "fsname is null");
            ValidateUtils.checkIllegalParameter(fsname.isBlank(), "fsname not specified");
            if (this.path != null) {
                throw new Exception("cannot specify both path and fsname parameters");
            }
            this.fsname = fsname;
            return this;
        }
    }
}

