/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;

public class WriteParams {
    private final Optional<String> textContent;
    private final Optional<byte[]> binaryContent;
    private final Optional<String> fileEncoding;
    private final boolean crlf;
    private final boolean binary;

    public WriteParams(Builder builder) {
        this.textContent = Optional.ofNullable(builder.textContent);
        this.binaryContent = Optional.ofNullable(builder.binaryContent);
        this.fileEncoding = Optional.ofNullable(builder.fileEncoding);
        this.crlf = builder.crlf;
        this.binary = builder.binary;
    }

    public Optional<String> getTextContent() {
        return this.textContent;
    }

    public Optional<byte[]> getBinaryContent() {
        return this.binaryContent;
    }

    public Optional<String> getFileEncoding() {
        return this.fileEncoding;
    }

    public boolean isCrlf() {
        return this.crlf;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String toString() {
        return "WriteParams{textContent=" + this.textContent + ", binaryContent=" + this.binaryContent + ", fileEncoding=" + this.fileEncoding + ", crlf=" + this.crlf + ", binary=" + this.binary + "}";
    }

    public static class Builder {
        private String textContent;
        private byte[] binaryContent;
        private String fileEncoding;
        private boolean crlf = false;
        private boolean binary = false;

        public WriteParams build() {
            return new WriteParams(this);
        }

        public Builder textContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public Builder binaryContent(byte[] binaryContent) {
            this.binaryContent = binaryContent;
            return this;
        }

        public Builder fileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return this;
        }

        public Builder crlf(boolean crlf) {
            this.crlf = crlf;
            return this;
        }

        public Builder binary(boolean binary) {
            this.binary = binary;
            return this;
        }
    }
}

