/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.ChangeOwnerParams;

public class UssChangeOwner {
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssChangeOwner(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssChangeOwner(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new Exception("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response change(String targetPath, String owner) throws Exception {
        return this.change(targetPath, new ChangeOwnerParams.Builder().owner(owner).build());
    }

    public Response change(String targetPath, ChangeOwnerParams params) throws Exception {
        ValidateUtils.checkNullParameter(targetPath == null, "targetPath is null");
        ValidateUtils.checkIllegalParameter(targetPath.isBlank(), "targetPath not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("request", "chown");
        params.getGroup().ifPresent(group -> jsonMap.put("group", (String)group));
        if (params.isRecursive()) {
            jsonMap.put("recursive", "true");
        }
        params.getLinkType().ifPresent(type -> jsonMap.put("links", type.getValue()));
        jsonMap.put("owner", params.getOwner().orElseThrow(() -> new Exception("owner not specified")));
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(jsonMap).toString());
        return RestUtils.getResponse(this.request);
    }
}

