/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.ChangeTagParams;
import zowe.client.sdk.zosfiles.uss.types.ChangeTagAction;
import zowe.client.sdk.zosfiles.uss.types.ChangeTagType;

public class UssChangeTag {
    private final ZosConnection connection;
    private ZoweRequest request;

    public UssChangeTag(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public UssChangeTag(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new Exception("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response changeToBinary(String fileNamePath) throws Exception {
        return this.changeCommon(fileNamePath, new ChangeTagParams.Builder().action(ChangeTagAction.SET).type(ChangeTagType.BINARY).build());
    }

    public Response changeToText(String fileNamePath, String codeSet) throws Exception {
        ValidateUtils.checkNullParameter(codeSet == null, "codeSet is null");
        ValidateUtils.checkIllegalParameter(codeSet.isBlank(), "codeSet not specified");
        return this.changeCommon(fileNamePath, new ChangeTagParams.Builder().action(ChangeTagAction.SET).type(ChangeTagType.TEXT).codeset(codeSet).build());
    }

    public Response remove(String fileNamePath) throws Exception {
        return this.changeCommon(fileNamePath, new ChangeTagParams.Builder().action(ChangeTagAction.REMOVE).build());
    }

    public Response retrieve(String fileNamePath) throws Exception {
        return this.changeCommon(fileNamePath, new ChangeTagParams.Builder().action(ChangeTagAction.LIST).build());
    }

    public Response changeCommon(String fileNamePath, ChangeTagParams params) throws Exception {
        ValidateUtils.checkNullParameter(fileNamePath == null, "fileNamePath is null");
        ValidateUtils.checkIllegalParameter(fileNamePath.isBlank(), "fileNamePath not specified");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkIllegalParameter(params.getAction().isEmpty(), "action not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(fileNamePath));
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("request", "chtag");
        jsonMap.put("action", params.getAction().get().getValue());
        params.getType().ifPresent(type -> jsonMap.put("type", type.getValue()));
        params.getCodeset().ifPresent(codeset -> jsonMap.put("codeset", (String)codeset));
        if (!params.isRecursive()) {
            jsonMap.put("recursive", "false");
        }
        params.getLinks().ifPresent(links -> jsonMap.put("links", links.getValue()));
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(jsonMap).toString());
        return RestUtils.getResponse(this.request);
    }
}

