/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseResponse;
import zowe.client.sdk.parse.JsonParseResponseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.TextGetRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.CommonJobParams;
import zowe.client.sdk.zosjobs.input.GetJobParams;
import zowe.client.sdk.zosjobs.input.JobFile;
import zowe.client.sdk.zosjobs.response.Job;

public class JobGet {
    private static final Logger LOG = LoggerFactory.getLogger(JobGet.class);
    private final ZosConnection connection;
    private ZoweRequest request;
    private String url;

    public JobGet(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public JobGet(ZosConnection connection, ZoweRequest request) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        this.request = request;
    }

    public String getJcl(String jobName, String jobId) throws Exception {
        return this.getJclCommon(new CommonJobParams(jobId, jobName));
    }

    public String getJclByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getJclCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null)));
    }

    public String getJclCommon(CommonJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files/JCL/records";
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        Response response = RestUtils.getResponse(this.request);
        return (String)response.getResponsePhrase().orElseThrow(() -> new Exception("no job jcl response phase"));
    }

    public Job getById(String jobId) throws Exception {
        List<Job> jobs = this.getCommon(new GetJobParams.Builder("*").jobId(jobId).build());
        if (jobs.isEmpty()) {
            throw new Exception("Job not found");
        }
        if (jobs.size() > 1) {
            throw new Exception("Expected 1 job returned but received " + jobs.size() + " jobs.");
        }
        return jobs.get(0);
    }

    public List<Job> getAll() throws Exception {
        return this.getCommon(null);
    }

    public List<Job> getByOwner(String owner) throws Exception {
        return this.getCommon(new GetJobParams.Builder(owner).build());
    }

    public List<Job> getByOwnerAndPrefix(String owner, String prefix) throws Exception {
        return this.getCommon(new GetJobParams.Builder(owner).prefix(prefix).build());
    }

    public List<Job> getByPrefix(String prefix) throws Exception {
        return this.getCommon(new GetJobParams.Builder("*").prefix(prefix).build());
    }

    public List<Job> getCommon(GetJobParams params) throws Exception {
        ArrayList<Job> jobs = new ArrayList<Job>();
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs?";
        if (params != null) {
            if (params.getOwner().isPresent()) {
                this.url = this.url + "owner=" + params.getOwner().get();
            }
            if (params.getPrefix().isPresent() && !"*".equals(params.getPrefix().get())) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "prefix=" + EncodeUtils.encodeURIComponent(params.getPrefix().get());
            }
            if (params.getMaxJobs().isPresent() && params.getMaxJobs().getAsInt() != 1000) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "max-jobs=" + params.getMaxJobs().getAsInt();
            }
            if (params.getJobId().isPresent()) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "jobid=" + params.getJobId().get();
            }
        } else {
            this.url = this.url + "owner=" + this.connection.getUser();
        }
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        String jsonStr = RestUtils.getResponse(this.request).getResponsePhrase().orElseThrow(() -> new Exception("no get job response phase")).toString();
        JSONArray results = (JSONArray)new JSONParser().parse(jsonStr);
        for (Object itemJsonObj : results) {
            JsonParseResponse parser = JsonParseResponseFactory.buildParser((JSONObject)itemJsonObj, ParseType.JOB);
            jobs.add((Job)parser.parseResponse());
        }
        return jobs;
    }

    public String getSpoolContent(JobFile jobFile) throws Exception {
        return this.getSpoolContentCommon(jobFile);
    }

    public String getSpoolContent(String jobName, String jobId, int spoolId) throws Exception {
        ValidateUtils.checkIllegalParameter(spoolId <= 0, "spool id not specified");
        CommonJobParams params = new CommonJobParams(jobId, jobName);
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files/" + spoolId + "/records";
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        Response response = RestUtils.getResponse(this.request);
        String spoolErrMsg = "no job spool content response phase";
        return (String)response.getResponsePhrase().orElseThrow(() -> new Exception("no job spool content response phase"));
    }

    public String getSpoolContentCommon(JobFile jobFile) throws Exception {
        ValidateUtils.checkNullParameter(jobFile == null, "jobFile is null");
        String jnErrMsg = "job name not specified";
        String jiErrMsg = "job id not specified";
        String jfiErrMsg = "job file id not specified";
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(jobFile.getJobName().orElseThrow(() -> new Exception("job name not specified"))) + "/" + jobFile.getJobId().orElseThrow(() -> new Exception("job id not specified")) + "/files/" + jobFile.getId().orElseThrow(() -> new Exception("job file id not specified")) + "/records";
        if (this.request == null || !(this.request instanceof TextGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        Response response = RestUtils.getResponse(this.request);
        return (String)response.getResponsePhrase().get();
    }

    public List<JobFile> getSpoolFiles(String jobName, String jobId) throws Exception {
        return this.getSpoolFilesCommon(new CommonJobParams(jobId, jobName));
    }

    public List<JobFile> getSpoolFilesCommon(CommonJobParams params) throws Exception {
        Response response;
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ArrayList<JobFile> files = new ArrayList<JobFile>();
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files";
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        try {
            response = RestUtils.getResponse(this.request);
        }
        catch (Exception e) {
            LOG.debug("JobGet::getSpoolFilesCommon - {}", (Object)e.getMessage());
            if (e.getMessage().contains("no response phrase returned")) {
                return files;
            }
            throw e;
        }
        String jpErrMsg = "no get job spool response phase";
        String jsonStr = response.getResponsePhrase().orElseThrow(() -> new Exception("no get job spool response phase")).toString();
        JSONArray results = (JSONArray)new JSONParser().parse(jsonStr);
        for (Object obj : results) {
            files.add((JobFile)JsonParseResponseFactory.buildParser((JSONObject)obj, ParseType.JOB_FILE).parseResponse());
        }
        return files;
    }

    public List<JobFile> getSpoolFilesByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getSpoolFilesCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null)));
    }

    public Job getStatus(String jobName, String jobId) throws Exception {
        return this.getStatusCommon(new CommonJobParams(jobId, jobName, true));
    }

    public Job getStatusCommon(CommonJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        this.url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get();
        if (params.isStepData().booleanValue()) {
            this.url = this.url + "?step-data=Y";
        }
        if (this.request == null || !(this.request instanceof JsonGetRequest)) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        String jsonStr = RestUtils.getResponse(this.request).getResponsePhrase().orElseThrow(() -> new Exception("no job get response phase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        JsonParseResponse parser = JsonParseResponseFactory.buildParser(jsonObject, ParseType.JOB);
        return (Job)parser.parseResponse();
    }

    public Job getStatusByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getStatusCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null), true));
    }

    public String getStatusValue(String jobName, String jobId) throws Exception {
        Job job = this.getStatusCommon(new CommonJobParams(jobId, jobName));
        return job.getStatus().orElseThrow(() -> new Exception("job status not returned"));
    }

    public String getStatusValueByJob(Job job) throws Exception {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        Job result = this.getStatusCommon(new CommonJobParams(job.getJobId().orElse(null), job.getJobName().orElse(null)));
        return result.getStatus().orElseThrow(() -> new Exception("job status not returned"));
    }

    public String getUrl() {
        return this.url;
    }
}

