/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.response;

import java.util.Optional;
import java.util.OptionalLong;

public class JobStepData {
    private final Optional<String> smfid;
    private final Optional<String> completion;
    private final Optional<Boolean> active;
    private final OptionalLong stepNumber;
    private final Optional<String> procStepName;
    private final Optional<String> stepName;
    private final Optional<String> programName;

    private JobStepData(Builder builder) {
        this.smfid = Optional.ofNullable(builder.smfid);
        this.completion = Optional.ofNullable(builder.completion);
        this.active = Optional.of(builder.active);
        this.stepNumber = builder.stepNumber == null ? OptionalLong.empty() : OptionalLong.of(builder.stepNumber);
        this.procStepName = Optional.ofNullable(builder.procStepName);
        this.stepName = Optional.ofNullable(builder.stepName);
        this.programName = Optional.ofNullable(builder.programName);
    }

    public Optional<Boolean> getActive() {
        return this.active;
    }

    public Optional<String> getCompletion() {
        return this.completion;
    }

    public Optional<String> getProcStepName() {
        return this.procStepName;
    }

    public Optional<String> getProgramName() {
        return this.programName;
    }

    public Optional<String> getSmfid() {
        return this.smfid;
    }

    public Optional<String> getStepName() {
        return this.stepName;
    }

    public OptionalLong getStepNumber() {
        return this.stepNumber;
    }

    public String toString() {
        return "JobStepData{smfid=" + this.smfid + ", completion=" + this.completion + ", active=" + this.active + ", stepNumber=" + this.stepNumber + ", procStepName=" + this.procStepName + ", stepName=" + this.stepName + ", programName=" + this.programName + "}";
    }

    public static class Builder {
        private String smfid;
        private String completion;
        private Boolean active;
        private Long stepNumber;
        private String procStepName;
        private String stepName;
        private String programName;

        public JobStepData build() {
            return new JobStepData(this);
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder completion(String completion) {
            this.completion = completion;
            return this;
        }

        public Builder procStepName(String procStepName) {
            this.procStepName = procStepName;
            return this;
        }

        public Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public Builder smfid(String smfid) {
            this.smfid = smfid;
            return this;
        }

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public Builder stepNumber(Long stepNumber) {
            this.stepNumber = stepNumber;
            return this;
        }
    }
}

