/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zoslogs.response;

import java.util.Optional;
import java.util.OptionalLong;

public class ZosLogItem {
    private final Optional<String> cart;
    private final Optional<String> color;
    private final Optional<String> jobName;
    private final Optional<String> message;
    private final Optional<String> messageId;
    private final Optional<String> replyId;
    private final Optional<String> system;
    private final Optional<String> type;
    private final Optional<String> subType;
    private final Optional<String> time;
    private final OptionalLong timeStamp;

    public Optional<String> getCart() {
        return this.cart;
    }

    public Optional<String> getColor() {
        return this.color;
    }

    public Optional<String> getJobName() {
        return this.jobName;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<String> getMessageId() {
        return this.messageId;
    }

    public Optional<String> getReplyId() {
        return this.replyId;
    }

    public Optional<String> getSystem() {
        return this.system;
    }

    public Optional<String> getType() {
        return this.type;
    }

    public Optional<String> getSubType() {
        return this.subType;
    }

    public Optional<String> getTime() {
        return this.time;
    }

    public OptionalLong getTimeStamp() {
        return this.timeStamp;
    }

    private ZosLogItem(Builder builder) {
        this.cart = Optional.ofNullable(builder.cart);
        this.color = Optional.ofNullable(builder.color);
        this.jobName = Optional.ofNullable(builder.jobName);
        this.message = Optional.ofNullable(builder.message);
        this.messageId = Optional.ofNullable(builder.messageId);
        this.replyId = Optional.ofNullable(builder.replyId);
        this.system = Optional.ofNullable(builder.system);
        this.type = Optional.ofNullable(builder.type);
        this.subType = Optional.ofNullable(builder.subType);
        this.time = Optional.ofNullable(builder.time);
        this.timeStamp = builder.timeStamp == 0L ? OptionalLong.empty() : OptionalLong.of(builder.timeStamp);
    }

    public static class Builder {
        private String cart;
        private String color;
        private String jobName;
        private String message;
        private String messageId;
        private String replyId;
        private String system;
        private String type;
        private String subType;
        private String time;
        private Long timeStamp;

        public ZosLogItem build() {
            return new ZosLogItem(this);
        }

        public Builder cart(String cart) {
            this.cart = cart;
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder replyId(String replyId) {
            this.replyId = replyId;
            return this;
        }

        public Builder system(String system) {
            this.system = system;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public Builder time(String time) {
            this.time = time;
            return this;
        }

        public Builder timeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }
    }
}

