/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.lifecycle;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.SendTsoParams;
import zowe.client.sdk.zostso.message.TsoMessage;
import zowe.client.sdk.zostso.message.TsoMessages;
import zowe.client.sdk.zostso.message.TsoResponseMessage;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.CollectedResponses;
import zowe.client.sdk.zostso.response.SendResponse;
import zowe.client.sdk.zostso.service.TsoResponseService;

public class SendTso {
    private static final Logger LOG = LoggerFactory.getLogger(SendTso.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public SendTso(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public SendTso(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new Exception("PUT_JSON request type required");
        }
        this.request = request;
    }

    private static SendResponse createResponse(CollectedResponses responses) throws Exception {
        return new SendResponse(true, responses.getTsos(), responses.getMessages().orElseThrow(() -> new Exception("no responses messages exist")));
    }

    public CollectedResponses getAllResponses(ZosmfTsoResponse tso) throws Exception {
        boolean done = false;
        StringBuilder messages = new StringBuilder();
        ArrayList<ZosmfTsoResponse> tsos = new ArrayList<ZosmfTsoResponse>();
        tsos.add(tso);
        while (!done) {
            if (!tso.getTsoData().isEmpty()) {
                for (TsoMessages tsoDatum : tso.getTsoData()) {
                    if (tsoDatum.getTsoMessage().isPresent()) {
                        TsoMessage tsoMsg = tsoDatum.getTsoMessage().get();
                        tsoMsg.getData().ifPresent(data -> {
                            messages.append((String)data);
                            messages.append("\n");
                        });
                        continue;
                    }
                    if (!tsoDatum.getTsoPrompt().isPresent()) continue;
                    if (messages.toString().contains("IKJ56602I COMMAND SYSTEM RESTARTING DUE TO ERROR")) {
                        String IKJ56602I = "IKJ56602I COMMAND SYSTEM RESTARTING DUE TO ERROR";
                        String msg = messages.toString();
                        int startIndex = msg.indexOf("IKJ56602I");
                        messages.delete(startIndex, startIndex + "IKJ56602I COMMAND SYSTEM RESTARTING DUE TO ERROR".length() + "\nREADY".length());
                        continue;
                    }
                    if (messages.length() <= 0 || !messages.toString().contains("READY")) continue;
                    done = true;
                }
            }
            if (done) continue;
            tso = this.getDataFromTSO(tso.getServletKey().orElseThrow(() -> new Exception("servlet key missing")));
            tsos.add(tso);
        }
        return new CollectedResponses(tsos, messages.toString());
    }

    private ZosmfTsoResponse getDataFromTSO(String servletKey) throws Exception {
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/tsoApp/tso/" + servletKey;
        LOG.debug("SendTso::getDataFromTSO - url {}", (Object)url);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        return new TsoResponseService(RestUtils.getResponse(this.request)).getZosmfTsoResponse();
    }

    private String getTsoResponseSendMessage(TsoResponseMessage tsoResponseMessage) throws Exception {
        String message = "{\"TSO RESPONSE\":{\"VERSION\":\"" + tsoResponseMessage.getVersion().orElseThrow(() -> new Exception("response version missing")) + "\",\"DATA\":\"" + tsoResponseMessage.getData().orElseThrow(() -> new Exception("response data missing")) + "\"}}";
        LOG.debug("SendTso::getTsoResponseSendMessage - message {}", (Object)message);
        return message;
    }

    public SendResponse sendDataToTSOCollect(String servletKey, String command) throws Exception {
        ValidateUtils.checkNullParameter(servletKey == null, "servletKey is null");
        ValidateUtils.checkNullParameter(command == null, "command is null");
        ValidateUtils.checkIllegalParameter(servletKey.isBlank(), "servletKey not specified");
        ValidateUtils.checkIllegalParameter(command.isBlank(), "command not specified");
        ZosmfTsoResponse putResponse = this.sendDataToTSOCommon(new SendTsoParams(servletKey, command));
        CollectedResponses responses = this.getAllResponses(putResponse);
        return SendTso.createResponse(responses);
    }

    public ZosmfTsoResponse sendDataToTSOCommon(SendTsoParams commandParams) throws Exception {
        ValidateUtils.checkNullParameter(commandParams == null, "commandParams is null");
        ValidateUtils.checkIllegalParameter(commandParams.getData().isBlank(), "commandParams data not specified");
        ValidateUtils.checkIllegalParameter(commandParams.getServletKey().isBlank(), "commandParams servletKey not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/tsoApp/tso/" + commandParams.getServletKey() + "?readReply=false";
        LOG.debug("SendTso::sendDataToTSOCommon - url {}", (Object)url);
        TsoResponseMessage tsoResponseMessage = new TsoResponseMessage("0100", commandParams.getData());
        String jobObjBody = this.getTsoResponseSendMessage(tsoResponseMessage);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(jobObjBody);
        return new TsoResponseService(RestUtils.getResponse(this.request)).getZosmfTsoResponse();
    }
}

