/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.message;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import zowe.client.sdk.zostso.message.TsoMessages;
import zowe.client.sdk.zostso.message.ZosmfMessages;

public class ZosmfTsoResponse {
    private final Optional<String> servletKey;
    private final Optional<String> queueId;
    private final Optional<String> ver;
    private final Optional<Boolean> reused;
    private final Optional<Boolean> timeout;
    private final List<ZosmfMessages> msgData;
    private final Optional<String> sessionId;
    private List<TsoMessages> tsoData;
    private final Optional<String> appData;

    private ZosmfTsoResponse(Builder builder) {
        this.servletKey = Optional.ofNullable(builder.servletKey);
        this.queueId = Optional.ofNullable(builder.queueId);
        this.ver = Optional.ofNullable(builder.ver);
        this.reused = Optional.ofNullable(builder.reused);
        this.timeout = Optional.ofNullable(builder.timeout);
        this.msgData = Objects.requireNonNullElse(builder.msgData, Collections.emptyList());
        this.sessionId = Optional.ofNullable(builder.sessionId);
        this.tsoData = Objects.requireNonNullElse(builder.tsoData, Collections.emptyList());
        this.appData = Optional.ofNullable(builder.appData);
    }

    public Optional<String> getServletKey() {
        return this.servletKey;
    }

    public Optional<String> getQueueId() {
        return this.queueId;
    }

    public Optional<String> getVer() {
        return this.ver;
    }

    public Optional<Boolean> getReused() {
        return this.reused;
    }

    public Optional<Boolean> getTimeout() {
        return this.timeout;
    }

    public List<ZosmfMessages> getMsgData() {
        return this.msgData;
    }

    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    public List<TsoMessages> getTsoData() {
        return this.tsoData;
    }

    public Optional<String> getAppData() {
        return this.appData;
    }

    public void setTsoData(List<TsoMessages> tsoData) {
        this.tsoData = Objects.requireNonNullElse(tsoData, Collections.emptyList());
    }

    public String toString() {
        return "ZosmfTsoResponse{servletKey=" + this.servletKey + ", queueId=" + this.queueId + ", ver=" + this.ver + ", reused=" + this.reused + ", timeout=" + this.timeout + ", msgData=" + this.msgData + ", sessionId=" + this.sessionId + ", tsoData=" + this.tsoData + ", appData=" + this.appData + "}";
    }

    public static class Builder {
        private String servletKey;
        private String queueId;
        private String ver;
        private Boolean reused;
        private Boolean timeout;
        private List<ZosmfMessages> msgData;
        private String sessionId;
        private List<TsoMessages> tsoData;
        private String appData;

        public Builder servletKey(String servletKey) {
            this.servletKey = servletKey;
            return this;
        }

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder ver(String ver) {
            this.ver = ver;
            return this;
        }

        public Builder reused(Boolean reused) {
            this.reused = reused;
            return this;
        }

        public Builder timeout(Boolean timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder msgData(List<ZosmfMessages> msgData) {
            this.msgData = msgData;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder tsoData(List<TsoMessages> tsoData) {
            this.tsoData = tsoData;
            return this;
        }

        public Builder tsoData(String appData) {
            this.appData = appData;
            return this;
        }

        public ZosmfTsoResponse build() {
            return new ZosmfTsoResponse(this);
        }
    }
}

