/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.service;

import java.util.ArrayList;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.parse.JsonParseResponse;
import zowe.client.sdk.parse.JsonParseResponseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.message.ZosmfMessages;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;
import zowe.client.sdk.zostso.response.StartStopResponse;

public class TsoResponseService {
    private Response tsoCmdResponse;
    private ZosmfTsoResponse zosmfPhaseResponse;

    public TsoResponseService(Response response) {
        this.tsoCmdResponse = response;
    }

    public TsoResponseService(ZosmfTsoResponse zosmfResponse) {
        this.zosmfPhaseResponse = zosmfResponse;
    }

    public ZosmfTsoResponse getZosmfTsoResponse() throws Exception {
        ZosmfTsoResponse result;
        ValidateUtils.checkNullParameter(this.tsoCmdResponse == null, "tsoCmdResponse is null");
        int statusCode = this.tsoCmdResponse.getStatusCode().get();
        if (this.tsoCmdResponse.getStatusCode().isPresent() && RestUtils.isHttpError(statusCode)) {
            ZosmfMessages zosmfMsg = new ZosmfMessages((String)this.tsoCmdResponse.getResponsePhrase().orElseThrow(() -> new Exception("no tsoCmdResponse phrase")), null, null);
            ArrayList<ZosmfMessages> zosmfMessages = new ArrayList<ZosmfMessages>();
            zosmfMessages.add(zosmfMsg);
            result = new ZosmfTsoResponse.Builder().msgData(zosmfMessages).build();
        } else {
            String jsonStr = this.tsoCmdResponse.getResponsePhrase().orElseThrow(() -> new Exception("no tsoCmdResponse phrase")).toString();
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
            JsonParseResponse parser = JsonParseResponseFactory.buildParser(jsonObject, ParseType.TSO_CONSOLE);
            result = (ZosmfTsoResponse)parser.parseResponse();
        }
        return result;
    }

    public StartStopResponse setStartStopResponse() {
        ValidateUtils.checkNullParameter(this.zosmfPhaseResponse == null, "zosmfPhaseResponse is null");
        StartStopResponse startStopResponse = new StartStopResponse(false, this.zosmfPhaseResponse, this.zosmfPhaseResponse.getServletKey().orElse(""));
        startStopResponse.setSuccess(this.zosmfPhaseResponse.getServletKey().isPresent());
        if (!this.zosmfPhaseResponse.getMsgData().isEmpty()) {
            ZosmfMessages zosmfMsg = this.zosmfPhaseResponse.getMsgData().get(0);
            String msgText = zosmfMsg.getMessageText().orElse("zOSMF unknown error response");
            startStopResponse.setFailureResponse(msgText);
        }
        return startStopResponse;
    }
}

