/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.parse.DatasetParseResponse;
import zowe.client.sdk.parse.JobFileParseResponse;
import zowe.client.sdk.parse.JobParseResponse;
import zowe.client.sdk.parse.JsonParseResponse;
import zowe.client.sdk.parse.MemberParseResponse;
import zowe.client.sdk.parse.MvsConsoleParseResponse;
import zowe.client.sdk.parse.PropsParseResponse;
import zowe.client.sdk.parse.SystemInfoParseResponse;
import zowe.client.sdk.parse.SystemsParseResponse;
import zowe.client.sdk.parse.TsoParseResponse;
import zowe.client.sdk.parse.TsoStopParseResponse;
import zowe.client.sdk.parse.UnixFileParseResponse;
import zowe.client.sdk.parse.UnixZfsParseResponse;
import zowe.client.sdk.parse.ZosLogItemParseResponse;
import zowe.client.sdk.parse.ZosLogReplyParseResponse;
import zowe.client.sdk.parse.type.ParseType;

public final class JsonParseResponseFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JsonParseResponseFactory.class);

    private JsonParseResponseFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static JsonParseResponse buildParser(ParseType type) throws Exception {
        JsonParseResponse parseResponse;
        LOG.debug(type.name());
        switch (type) {
            case DATASET: {
                parseResponse = DatasetParseResponse.getInstance();
                break;
            }
            case JOB: {
                parseResponse = JobParseResponse.getInstance();
                break;
            }
            case JOB_FILE: {
                parseResponse = JobFileParseResponse.getInstance();
                break;
            }
            case MEMBER: {
                parseResponse = MemberParseResponse.getInstance();
                break;
            }
            case MVS_CONSOLE: {
                parseResponse = MvsConsoleParseResponse.getInstance();
                break;
            }
            case PROPS: {
                parseResponse = PropsParseResponse.getInstance();
                break;
            }
            case TSO_CONSOLE: {
                parseResponse = TsoParseResponse.getInstance();
                break;
            }
            case TSO_STOP: {
                parseResponse = TsoStopParseResponse.getInstance();
                break;
            }
            case UNIX_FILE: {
                parseResponse = UnixFileParseResponse.getInstance();
                break;
            }
            case UNIX_ZFS: {
                parseResponse = UnixZfsParseResponse.getInstance();
                break;
            }
            case ZOS_LOG_ITEM: {
                parseResponse = ZosLogItemParseResponse.getInstance();
                break;
            }
            case ZOS_LOG_REPLY: {
                parseResponse = ZosLogReplyParseResponse.getInstance();
                break;
            }
            case ZOSMF_SYSTEMS: {
                parseResponse = SystemsParseResponse.getInstance();
                break;
            }
            case ZOSMF_INFO: {
                parseResponse = SystemInfoParseResponse.getInstance();
                break;
            }
            default: {
                throw new IllegalStateException("no valid ParseType type specified");
            }
        }
        return parseResponse;
    }
}

