/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;

public final class RestUtils {
    private RestUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Response getResponse(ZoweRequest request) throws Exception {
        Response response = request.executeRequest();
        String errMsg = "no response status code returned";
        int statusCode = response.getStatusCode().orElseThrow(() -> new IllegalStateException("no response status code returned"));
        if (RestUtils.isHttpError(statusCode)) {
            AtomicReference<String> responsePhrase = new AtomicReference<String>();
            response.getResponsePhrase().ifPresent(responsePhrase::set);
            if (responsePhrase.get() instanceof byte[]) {
                try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])responsePhrase.get()), StandardCharsets.UTF_8);){
                    String line;
                    BufferedReader br = new BufferedReader(inputStreamReader);
                    StringBuilder content = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        content.append(line).append("\n");
                    }
                    responsePhrase.set(content.substring(0, content.length() - 1));
                    br.close();
                }
            }
            String responsePhraseStr = String.valueOf(responsePhrase.get());
            String statusText = response.getStatusText().orElse("n\\a");
            String httpErrMsg = "http status error code: " + statusCode + ", status text: " + statusText;
            if (!statusText.equalsIgnoreCase(responsePhraseStr)) {
                httpErrMsg = httpErrMsg + ", response phrase: " + responsePhraseStr;
            }
            throw new Exception(httpErrMsg);
        }
        return response;
    }

    public static boolean isHttpError(int statusCode) {
        return !(statusCode >= 200 && statusCode <= 299 || statusCode >= 100 && statusCode <= 199);
    }

    public static boolean isUrlNotValid(String url) {
        try {
            new URL(url).toURI();
            return false;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return true;
        }
    }
}

