/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.input;

import java.util.Optional;
import java.util.OptionalInt;

public class CreateParams {
    private final Optional<String> volser;
    private final Optional<String> unit;
    private final Optional<String> dsorg;
    private final Optional<String> alcunit;
    private final OptionalInt primary;
    private final OptionalInt secondary;
    private final OptionalInt dirblk;
    private final OptionalInt avgblk;
    private final Optional<String> recfm;
    private final OptionalInt blksize;
    private final OptionalInt lrecl;
    private final Optional<String> storclass;
    private final Optional<String> mgntclass;
    private final Optional<String> dataclass;
    private final Optional<String> dsntype;
    private final boolean showAttributes;
    private final Optional<String> size;
    private final Optional<String> responseTimeout;

    private CreateParams(Builder builder) {
        this.volser = Optional.ofNullable(builder.volser);
        this.unit = Optional.ofNullable(builder.unit);
        this.dsorg = Optional.ofNullable(builder.dsorg);
        this.alcunit = Optional.ofNullable(builder.alcunit);
        this.primary = builder.primary == null ? OptionalInt.empty() : OptionalInt.of(builder.primary);
        this.secondary = builder.secondary == null ? OptionalInt.empty() : OptionalInt.of(builder.secondary);
        this.dirblk = builder.dirblk == null ? OptionalInt.empty() : OptionalInt.of(builder.dirblk);
        this.avgblk = builder.avgblk == null ? OptionalInt.empty() : OptionalInt.of(builder.avgblk);
        this.recfm = Optional.ofNullable(builder.recfm);
        this.blksize = builder.blksize == null ? OptionalInt.empty() : OptionalInt.of(builder.blksize);
        this.lrecl = builder.lrecl == null ? OptionalInt.empty() : OptionalInt.of(builder.lrecl);
        this.storclass = Optional.ofNullable(builder.storclass);
        this.mgntclass = Optional.ofNullable(builder.mgntclass);
        this.dataclass = Optional.ofNullable(builder.dataclass);
        this.dsntype = Optional.ofNullable(builder.dsntype);
        this.showAttributes = builder.showAttributes;
        this.size = Optional.ofNullable(builder.size);
        this.responseTimeout = Optional.ofNullable(builder.responseTimeout);
    }

    public Optional<String> getAlcunit() {
        return this.alcunit;
    }

    public OptionalInt getAvgblk() {
        return this.avgblk;
    }

    public OptionalInt getBlksize() {
        return this.blksize;
    }

    public Optional<String> getDataclass() {
        return this.dataclass;
    }

    public OptionalInt getDirblk() {
        return this.dirblk;
    }

    public Optional<String> getDsntype() {
        return this.dsntype;
    }

    public Optional<String> getDsorg() {
        return this.dsorg;
    }

    public OptionalInt getLrecl() {
        return this.lrecl;
    }

    public Optional<String> getMgntclass() {
        return this.mgntclass;
    }

    public OptionalInt getPrimary() {
        return this.primary;
    }

    public Optional<String> getRecfm() {
        return this.recfm;
    }

    public Optional<String> getResponseTimeout() {
        return this.responseTimeout;
    }

    public OptionalInt getSecondary() {
        return this.secondary;
    }

    public boolean isShowAttributes() {
        return this.showAttributes;
    }

    public Optional<String> getSize() {
        return this.size;
    }

    public Optional<String> getStorclass() {
        return this.storclass;
    }

    public Optional<String> getUnit() {
        return this.unit;
    }

    public Optional<String> getVolser() {
        return this.volser;
    }

    public String toString() {
        return "CreateOptions{volser=" + this.volser + ", unit=" + this.unit + ", dsorg=" + this.dsorg + ", alcunit=" + this.alcunit + ", primary=" + this.primary + ", secondary=" + this.secondary + ", dirblk=" + this.dirblk + ", avgblk=" + this.avgblk + ", recfm=" + this.recfm + ", blksize=" + this.blksize + ", lrecl=" + this.lrecl + ", storclass=" + this.storclass + ", mgntclass=" + this.mgntclass + ", dataclass=" + this.dataclass + ", dsntype=" + this.dsntype + ", showAttributes=" + this.showAttributes + ", size=" + this.size + ", responseTimeout=" + this.responseTimeout + "}";
    }

    public static class Builder {
        private String volser;
        private String unit;
        private String dsorg;
        private String alcunit;
        private Integer primary;
        private Integer secondary;
        private Integer dirblk;
        private Integer avgblk;
        private String recfm;
        private Integer blksize;
        private Integer lrecl;
        private String storclass;
        private String mgntclass;
        private String dataclass;
        private String dsntype;
        private boolean showAttributes;
        private String size;
        private String responseTimeout;

        public Builder alcunit(String alcunit) {
            this.alcunit = alcunit;
            return this;
        }

        public Builder avgblk(Integer avgblk) {
            this.avgblk = avgblk;
            return this;
        }

        public Builder blksize(Integer blksize) {
            this.blksize = blksize;
            return this;
        }

        public CreateParams build() {
            return new CreateParams(this);
        }

        public Builder dataclass(String dataclass) {
            this.dataclass = dataclass;
            return this;
        }

        public Builder dirblk(Integer dirblk) {
            this.dirblk = dirblk;
            return this;
        }

        public Builder dsntype(String dsntype) {
            this.dsntype = dsntype;
            return this;
        }

        public Builder dsorg(String dsorg) {
            this.dsorg = dsorg;
            return this;
        }

        public Builder lrecl(Integer lrecl) {
            this.lrecl = lrecl;
            return this;
        }

        public Builder mgntclass(String mgntclass) {
            this.mgntclass = mgntclass;
            return this;
        }

        public Builder primary(Integer primary) {
            this.primary = primary;
            return this;
        }

        public Builder recfm(String recfm) {
            this.recfm = recfm;
            return this;
        }

        public Builder responseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Builder secondary(Integer secondary) {
            this.secondary = secondary;
            return this;
        }

        public Builder showAttributes(boolean showAttributes) {
            this.showAttributes = showAttributes;
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder storclass(String storclass) {
            this.storclass = storclass;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder volser(String volser) {
            this.volser = volser;
            return this;
        }
    }
}

