/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.StreamGetRequest;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.DownloadParams;
import zowe.client.sdk.zosfiles.dsn.input.ListParams;
import zowe.client.sdk.zosfiles.dsn.methods.DsnList;
import zowe.client.sdk.zosfiles.dsn.response.Dataset;
import zowe.client.sdk.zosfiles.dsn.types.AttributeType;

public class DsnGet {
    private final ZosConnection connection;
    private ZoweRequest request;

    public DsnGet(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public DsnGet(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof StreamGetRequest)) {
            throw new IllegalStateException("GET_STREAM request type required");
        }
        this.request = request;
    }

    public Dataset getDsnInfo(String dataSetName) throws Exception {
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        Dataset emptyDataSet = new Dataset.Builder().dsname(dataSetName).build();
        String[] tokens = dataSetName.split("\\.");
        int length = tokens.length - 1;
        if (1 >= length) {
            return emptyDataSet;
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            str.append(tokens[i]);
            str.append(".");
        }
        String dataSetSearchStr = str.toString();
        dataSetSearchStr = dataSetSearchStr.substring(0, str.length() - 1);
        DsnList dsnList = new DsnList(this.connection);
        ListParams params = new ListParams.Builder().attribute(AttributeType.BASE).build();
        List<Dataset> dsLst = dsnList.listDsn(dataSetSearchStr, params);
        Optional<Dataset> dataSet = dsLst.stream().filter(d -> d.getDsname().orElse("n/a").contains(dataSetName)).findFirst();
        return dataSet.orElse(emptyDataSet);
    }

    public InputStream get(String dataSetName, DownloadParams params) throws Exception {
        Object value;
        String key;
        ValidateUtils.checkNullParameter(params == null, "params is null");
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/";
        if (params.getVolume().isPresent()) {
            url = url + "-(" + params.getVolume().get() + ")/";
        }
        url = url + EncodeUtils.encodeURIComponent(dataSetName);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (params.isBinary()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_BINARY").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_BINARY").get(1);
            headers.put(key, (String)value);
        } else if (params.getEncoding().isPresent()) {
            key = "X_IBM_TEXT";
            value = "X_IBM_TEXTX_IBM_TEXT_ENCODING" + params.getEncoding();
            headers.put(key, (String)value);
        }
        if (params.isReturnEtag()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RETURN_ETAG").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RETURN_ETAG").get(1);
            headers.put(key, (String)value);
        }
        if (params.getResponseTimeout().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RESPONSE_TIMEOUT").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)params.getResponseTimeout().toString()).get(1);
            headers.put(key, (String)value);
        }
        key = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(0);
        value = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(1);
        headers.put(key, (String)value);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_STREAM);
        }
        this.request.setUrl(url);
        this.request.setHeaders(headers);
        return new ByteArrayInputStream((byte[])RestUtils.getResponse(this.request).getResponsePhrase().orElseThrow(() -> new IllegalStateException("no dsn get response phrase")));
    }
}

