/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;

public class CopyParams {
    private final Optional<String> from;
    private final boolean overwrite;
    private final boolean recursive;

    public CopyParams(Builder builder) {
        this.from = Optional.ofNullable(builder.from);
        this.overwrite = builder.overwrite;
        this.recursive = builder.recursive;
    }

    public Optional<String> getFrom() {
        return this.from;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public String toString() {
        return "CopyParams{from=" + this.getFrom() + ", overwrite=" + this.isOverwrite() + ", recursive=" + this.isRecursive() + "}";
    }

    public static class Builder {
        private String from;
        private boolean overwrite = true;
        private boolean recursive = false;

        public CopyParams build() {
            return new CopyParams(this);
        }

        public Builder from(String from) {
            ValidateUtils.checkNullParameter(from == null, "from is null");
            ValidateUtils.checkIllegalParameter(from.isBlank(), "from not specified");
            this.from = from;
            return this;
        }

        public Builder overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }
    }
}

