/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import java.util.OptionalInt;

public class GetParams {
    private final Optional<String> search;
    private final Optional<String> research;
    private final boolean insensitive;
    private final OptionalInt maxreturnsize;
    private final int queryCount;
    private final boolean binary;
    private final Optional<String> recordsRange;

    public GetParams(Builder builder) {
        this.search = Optional.ofNullable(builder.search);
        this.research = Optional.ofNullable(builder.research);
        this.insensitive = builder.insensitive;
        this.maxreturnsize = builder.maxreturnsize == null ? OptionalInt.empty() : OptionalInt.of(builder.maxreturnsize);
        this.queryCount = builder.queryCount;
        this.binary = builder.binary;
        this.recordsRange = Optional.ofNullable(builder.recordsRange);
    }

    public Optional<String> getSearch() {
        return this.search;
    }

    public Optional<String> getResearch() {
        return this.research;
    }

    public boolean isInsensitive() {
        return this.insensitive;
    }

    public OptionalInt getMaxReturnSize() {
        return this.maxreturnsize;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public Optional<String> getRecordsRange() {
        return this.recordsRange;
    }

    public String toString() {
        return "GetParams{search=" + this.search + ", research=" + this.research + ", insensitive=" + this.insensitive + ", maxreturnsize=" + this.maxreturnsize + ", queryCount=" + this.queryCount + ", binary=" + this.binary + ", queryCount=" + this.queryCount + ", recordsRange=" + this.recordsRange + "}";
    }

    public static class Builder {
        private String search;
        private String research;
        private boolean insensitive = true;
        private Integer maxreturnsize;
        private boolean binary = false;
        private int queryCount = 0;
        private String recordsRange;

        public GetParams build() {
            return new GetParams(this);
        }

        public Builder search(String search) throws Exception {
            if (this.research != null) {
                throw new IllegalStateException("cannot specify both search and research parameters");
            }
            this.search = search;
            ++this.queryCount;
            return this;
        }

        public Builder research(String research) {
            if (this.search != null) {
                throw new IllegalStateException("cannot specify both search and research parameters");
            }
            this.research = research;
            ++this.queryCount;
            return this;
        }

        public Builder insensitive(boolean insensitive) {
            this.insensitive = insensitive;
            ++this.queryCount;
            return this;
        }

        public Builder maxreturnsize(int maxreturnsize) {
            this.maxreturnsize = maxreturnsize;
            ++this.queryCount;
            return this;
        }

        public Builder binary(boolean binary) {
            this.binary = binary;
            return this;
        }

        public Builder recordsRange(String recordsRange) {
            this.recordsRange = recordsRange;
            return this;
        }
    }
}

