/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.input;

import java.util.Optional;
import java.util.OptionalInt;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.types.JobStatus;

public class MonitorJobWaitForParams {
    private final Optional<String> jobId;
    private final Optional<String> jobName;
    private OptionalInt watchDelay;
    private Optional<JobStatus.Type> jobStatus;
    private OptionalInt attempts;
    private OptionalInt lineLimit;

    private MonitorJobWaitForParams(Builder builder) {
        this.jobId = Optional.ofNullable(builder.jobId);
        this.jobName = Optional.ofNullable(builder.jobName);
        this.watchDelay = builder.watchDelay;
        this.jobStatus = Optional.ofNullable(builder.jobStatus);
        this.attempts = builder.attempts;
        this.lineLimit = builder.lineLimit;
    }

    public OptionalInt getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = OptionalInt.of(attempts);
    }

    public Optional<String> getJobId() {
        return this.jobId;
    }

    public Optional<String> getJobName() {
        return this.jobName;
    }

    public Optional<JobStatus.Type> getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus.Type jobStatus) {
        this.jobStatus = Optional.ofNullable(jobStatus);
    }

    public OptionalInt getLineLimit() {
        return this.lineLimit;
    }

    public void setLineLimit(int lineLimit) {
        this.lineLimit = OptionalInt.of(lineLimit);
    }

    public OptionalInt getWatchDelay() {
        return this.watchDelay;
    }

    public void setWatchDelay(int watchDelay) {
        this.watchDelay = OptionalInt.of(watchDelay);
    }

    public String toString() {
        return "MonitorJobWaitForParams{jobId=" + this.jobId + ", jobName=" + this.jobName + ", watchDelay=" + this.watchDelay + ", jobStatus=" + this.jobStatus + ", attempts=" + this.attempts + ", lineLimit=" + this.lineLimit + "}";
    }

    public static class Builder {
        private final String jobId;
        private final String jobName;
        private OptionalInt watchDelay = OptionalInt.empty();
        private JobStatus.Type jobStatus;
        private OptionalInt attempts = OptionalInt.empty();
        private OptionalInt lineLimit = OptionalInt.empty();

        public Builder(String jobName, String jobId) {
            ValidateUtils.checkNullParameter(jobName == null, "job name is null");
            ValidateUtils.checkIllegalParameter(jobName.isBlank(), "job name not specified");
            ValidateUtils.checkNullParameter(jobId == null, "job id is null");
            ValidateUtils.checkIllegalParameter(jobId.isBlank(), "job name not specified");
            this.jobName = jobName;
            this.jobId = jobId;
        }

        public Builder attempts(int attempts) {
            this.attempts = OptionalInt.of(attempts);
            return this;
        }

        public MonitorJobWaitForParams build() {
            return new MonitorJobWaitForParams(this);
        }

        public Builder jobStatus(JobStatus.Type jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder lineLimit(int lineLimit) {
            this.lineLimit = OptionalInt.of(lineLimit);
            return this;
        }

        public Builder watchDelay(int watchDelay) {
            this.watchDelay = OptionalInt.of(watchDelay);
            return this;
        }
    }
}

