/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.JsonPutRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.ModifyJobParams;
import zowe.client.sdk.zosjobs.response.Job;

public class JobCancel {
    private static final Logger LOG = LoggerFactory.getLogger(JobCancel.class);
    private final ZosConnection connection;
    private ZoweRequest request;

    public JobCancel(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public JobCancel(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonPutRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response cancel(String jobName, String jobId, String version) throws Exception {
        return this.cancelCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }

    public Response cancelByJob(Job job, String version) throws Exception {
        return this.cancelCommon(new ModifyJobParams.Builder(job.getJobName().orElse(""), job.getJobId().orElse("")).version(version).build());
    }

    public Response cancelCommon(ModifyJobParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + params.getJobName().orElseThrow(() -> new IllegalArgumentException("job name not specified")) + "/" + params.getJobId().orElseThrow(() -> new IllegalArgumentException("job id not specified"));
        String version = params.getVersion().orElse("1.0");
        if ("1.0".equals(version)) {
            LOG.debug("version 1.0 specified which will result in asynchronous processing for the request");
        } else if ("2.0".equals(version)) {
            LOG.debug("version 2.0 specified which will result in synchronous processing for the request");
        } else {
            throw new IllegalArgumentException("invalid version specified");
        }
        HashMap<String, String> cancelMap = new HashMap<String, String>();
        cancelMap.put("request", "cancel");
        cancelMap.put("version", version);
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(cancelMap).toString());
        return RestUtils.getResponse(this.request);
    }
}

