/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zoslogs.method;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseResponseFactory;
import zowe.client.sdk.parse.ZosLogItemParseResponse;
import zowe.client.sdk.parse.ZosLogReplyParseResponse;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zoslogs.input.ZosLogParams;
import zowe.client.sdk.zoslogs.response.ZosLogItem;
import zowe.client.sdk.zoslogs.response.ZosLogReply;

public class ZosLog {
    private static final String RESOURCE = "/zosmf/restconsoles/v1/log?";
    private final ZosConnection connection;
    private ZoweRequest request;

    public ZosLog(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public ZosLog(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
        if (!(request instanceof JsonGetRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosLogReply issueCommand(ZosLogParams params) throws Exception {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String defaultUrl = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + RESOURCE;
        StringBuilder url = new StringBuilder(defaultUrl);
        params.getStartTime().ifPresent(time -> {
            if (ZosLog.isNotValidDate(time)) {
                throw new IllegalArgumentException("startTime date format is invalid");
            }
            DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault());
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(time, formatter);
            url.append("time=").append(zonedDateTime);
        });
        params.getTimeRange().ifPresent(timeRange -> url.append("&timeRange=").append((String)timeRange));
        params.getDirection().ifPresent(direction -> url.append("&direction=").append(direction.getValue()));
        params.getHardCopy().ifPresent(hardCopy -> url.append("&hardcopy=").append(hardCopy.getValue()));
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(url.toString());
        String jsonStr = RestUtils.getResponse(this.request).getResponsePhrase().orElseThrow(() -> new IllegalStateException("no zos log response phrase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        JSONArray jsonArray = new JSONArray();
        if (jsonObject.get("items") != null) {
            jsonArray = (JSONArray)jsonObject.get("items");
        }
        ArrayList<ZosLogItem> zosLogItems = new ArrayList<ZosLogItem>();
        boolean isProcessResponse = params.isProcessResponses();
        for (Object itemJsonObj : jsonArray) {
            ZosLogItemParseResponse parser = (ZosLogItemParseResponse)JsonParseResponseFactory.buildParser(ParseType.ZOS_LOG_ITEM).setJsonObject((JSONObject)itemJsonObj);
            parser.setProcessResponse(isProcessResponse);
            zosLogItems.add(parser.parseResponse());
        }
        ZosLogReplyParseResponse parser = (ZosLogReplyParseResponse)JsonParseResponseFactory.buildParser(ParseType.ZOS_LOG_REPLY).setJsonObject(jsonObject);
        parser.setZosLogItems(zosLogItems);
        return parser.parseResponse();
    }

    private static boolean isNotValidDate(String value) {
        String patternStr = ".*[0-9]-.*[0-9]-.*[0-9][T].*[0-9][:]*[0-9][:]*[0-9][Z]";
        Pattern pattern = Pattern.compile(".*[0-9]-.*[0-9]-.*[0-9][T].*[0-9][:]*[0-9][:]*[0-9][Z]");
        Matcher matcher = pattern.matcher(value);
        return !matcher.matches();
    }
}

