/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfinfo.methods;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseResponseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.JsonGetRequest;
import zowe.client.sdk.rest.ZoweRequest;
import zowe.client.sdk.rest.ZoweRequestFactory;
import zowe.client.sdk.rest.type.ZoweRequestType;
import zowe.client.sdk.utility.RestUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfinfo.response.ZosmfInfoResponse;

public class ZosmfStatus {
    private final ZosConnection connection;
    private ZoweRequest request;

    public ZosmfStatus(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public ZosmfStatus(ZosConnection connection, ZoweRequest request) throws Exception {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof JsonGetRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosmfInfoResponse get() throws Exception {
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/info";
        if (this.request == null) {
            this.request = ZoweRequestFactory.buildRequest(this.connection, ZoweRequestType.GET_JSON);
        }
        this.request.setUrl(url);
        String jsonStr = RestUtils.getResponse(this.request).getResponsePhrase().orElseThrow(() -> new IllegalStateException("no z/osmf status response phrase")).toString();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
        return (ZosmfInfoResponse)JsonParseResponseFactory.buildParser(ParseType.ZOSMF_INFO).setJsonObject(jsonObject).parseResponse();
    }
}

