/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.input;

import java.util.Map;
import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;

public class SubmitJobParams {
    private Optional<String> jobDataSet;
    private Optional<Map<String, String>> jclSymbols = Optional.empty();

    public SubmitJobParams(String jobDataSet) {
        this.jobDataSet = Optional.ofNullable(jobDataSet);
    }

    public SubmitJobParams(String jobDataSet, Map<String, String> jclSymbols) {
        ValidateUtils.checkNullParameter(jobDataSet == null, "jobDataSet is null");
        ValidateUtils.checkIllegalParameter(jobDataSet.isEmpty(), "jobDataSet not specified");
        this.jobDataSet = Optional.of(jobDataSet);
        this.jclSymbols = Optional.ofNullable(jclSymbols);
    }

    public Optional<Map<String, String>> getJclSymbols() {
        return this.jclSymbols;
    }

    public void setJclSymbols(Map<String, String> jclSymbols) {
        this.jclSymbols = Optional.ofNullable(jclSymbols);
    }

    public Optional<String> getJobDataSet() {
        return this.jobDataSet;
    }

    public void setJobDataSet(String jobDataSet) {
        this.jobDataSet = Optional.ofNullable(jobDataSet);
    }

    public String toString() {
        return "SubmitJobParams{jobDataSet=" + this.jobDataSet + ", jclSymbols=" + this.jclSymbols + "}";
    }
}

