/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.input;

import java.util.Optional;
import zowe.client.sdk.zosfiles.dsn.types.AttributeType;

public class ListParams {
    private final Optional<String> volume;
    private final Optional<AttributeType> attribute;
    private final Optional<String> maxLength;
    private final Optional<String> start;
    private final Optional<String> recall;
    private final Optional<String> pattern;
    private final Optional<String> responseTimeout;

    private ListParams(Builder builder) {
        this.volume = Optional.ofNullable(builder.volume);
        this.attribute = Optional.ofNullable(builder.attribute);
        this.maxLength = Optional.ofNullable(builder.maxLength);
        this.start = Optional.ofNullable(builder.start);
        this.recall = Optional.ofNullable(builder.recall);
        this.pattern = Optional.ofNullable(builder.pattern);
        this.responseTimeout = Optional.ofNullable(builder.responseTimeout);
    }

    public Optional<AttributeType> getAttribute() {
        return this.attribute;
    }

    public Optional<String> getMaxLength() {
        return this.maxLength;
    }

    public Optional<String> getPattern() {
        return this.pattern;
    }

    public Optional<String> getRecall() {
        return this.recall;
    }

    public Optional<String> getResponseTimeout() {
        return this.responseTimeout;
    }

    public Optional<String> getStart() {
        return this.start;
    }

    public Optional<String> getVolume() {
        return this.volume;
    }

    public String toString() {
        return "ListParams{volume=" + this.volume + ", attribute=" + this.attribute + ", maxLength=" + this.maxLength + ", start=" + this.start + ", recall=" + this.recall + ", pattern=" + this.pattern + ", responseTimeout=" + this.responseTimeout + "}";
    }

    public static class Builder {
        private String volume;
        private AttributeType attribute;
        private String maxLength;
        private String start;
        private String recall;
        private String pattern;
        private String responseTimeout;

        public Builder volume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder attribute(AttributeType attribute) {
            this.attribute = attribute;
            return this;
        }

        public Builder maxLength(String maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder start(String start) {
            this.start = start;
            return this;
        }

        public Builder recall(String recall) {
            this.recall = recall;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder responseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public ListParams build() {
            return new ListParams(this);
        }
    }
}

