/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.rest;

import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class PutStreamZosmfRequest
extends ZosmfRequest {
    private byte[] body;

    public PutStreamZosmfRequest(ZosConnection connection) {
        super(connection);
    }

    @Override
    public Response executeRequest() throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(this.url == null, "url is null");
        ValidateUtils.checkNullParameter(this.body == null, "body is null");
        HttpResponse<JsonNode> reply = ((HttpRequestWithBody)Unirest.put(this.url).headers(this.headers)).body(this.body).asJson();
        return this.buildResponse(reply);
    }

    @Override
    public void setBody(Object body) {
        this.body = (byte[])body;
    }

    @Override
    public void setStandardHeaders() {
        this.headers.put("Authorization", "Basic " + EncodeUtils.encodeAuthComponent(this.connection));
        this.headers.put("Content-Type", "binary");
        this.headers.put(X_CSRF_ZOSMF_HEADER_KEY, X_CSRF_ZOSMF_HEADER_VALUE);
    }
}

