/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosuss.method;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.SshConnection;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.utility.timer.WaitUtil;
import zowe.client.sdk.zosuss.exception.IssueUssException;

public class IssueUss {
    private static final Logger LOG = LoggerFactory.getLogger(IssueUss.class);
    private final SshConnection connection;

    public IssueUss(SshConnection connection) {
        ValidateUtils.checkSshConnection(connection);
        this.connection = connection;
    }

    public String issueCommand(String command, int timeout) throws IssueUssException {
        Session session = null;
        Channel channel = null;
        try {
            String string;
            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            try {
                session = new JSch().getSession(this.connection.getUser(), this.connection.getHost(), this.connection.getPort());
                session.setPassword(this.connection.getPassword());
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                config.put("PreferredAuthentications", "password");
                session.setConfig(config);
                session.connect(timeout);
                channel = (ChannelExec)session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                channel.setOutputStream(responseStream);
                channel.connect();
                while (channel.isConnected()) {
                    WaitUtil.wait(1000);
                }
                string = responseStream.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        responseStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.debug("IOException error " + e);
                    throw new IssueUssException(e.getMessage());
                }
                catch (JSchException e) {
                    LOG.debug("JSchException error " + e);
                    throw new IssueUssException(e.getMessage());
                }
            }
            responseStream.close();
            return string;
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
            if (channel != null) {
                channel.disconnect();
            }
        }
    }
}

