/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kong.unirest.Config;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponseSummary;
import kong.unirest.RawResponse;
import kong.unirest.ResponseSummary;

public abstract class RawResponseBase
implements RawResponse {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    protected Config config;
    private final HttpRequestSummary reqSum;

    protected RawResponseBase(Config config, HttpRequestSummary reqSum) {
        this.config = config;
        this.reqSum = reqSum;
    }

    protected String getCharSet() {
        String contentType = this.getContentType();
        String responseCharset = this.getCharsetFromContentType(contentType);
        if (responseCharset != null && !responseCharset.trim().equals("")) {
            return responseCharset;
        }
        return this.config.getDefaultResponseEncoding();
    }

    private String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m4 = CHARSET_PATTERN.matcher(contentType);
        if (m4.find()) {
            return m4.group(1).trim().toUpperCase();
        }
        return null;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public HttpResponseSummary toSummary() {
        return new ResponseSummary(this);
    }

    @Override
    public HttpRequestSummary getRequestSummary() {
        return this.reqSum;
    }
}

