/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.parse.JsonParse;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.message.TsoMessage;
import zowe.client.sdk.zostso.message.TsoMessages;
import zowe.client.sdk.zostso.message.TsoPromptMessage;
import zowe.client.sdk.zostso.message.ZosmfTsoResponse;

public final class TsoJsonParse
implements JsonParse {
    private TsoJsonParse() {
    }

    public static TsoJsonParse getInstance() {
        return Holder.instance;
    }

    @Override
    public synchronized ZosmfTsoResponse parseResponse(Object ... args) {
        ValidateUtils.checkNullParameter(args[0] == null, "data is null");
        JSONObject data = (JSONObject)args[0];
        ZosmfTsoResponse response = new ZosmfTsoResponse.Builder().queueId(data.get("queueID") != null ? (String)data.get("queueID") : null).ver(data.get("ver") != null ? (String)data.get("ver") : null).servletKey(data.get("servletKey") != null ? (String)data.get("servletKey") : null).reused(data.get("reused") != null && (Boolean)data.get("reused") != false).timeout(data.get("timeout") != null && (Boolean)data.get("timeout") != false).build();
        ArrayList tsoMessagesLst = new ArrayList();
        Optional<JSONArray> tsoData = Optional.ofNullable((JSONArray)data.get("tsoData"));
        tsoData.ifPresent(d -> {
            d.forEach(item -> {
                JSONObject obj = (JSONObject)item;
                TsoMessages tsoMessages = new TsoMessages();
                TsoJsonParse.parseJsonTsoMessage(tsoMessagesLst, obj, tsoMessages);
                TsoJsonParse.parseJsonTsoPrompt(tsoMessagesLst, obj, tsoMessages);
            });
            response.setTsoData(tsoMessagesLst);
        });
        return response;
    }

    private static void parseJsonTsoMessage(List<TsoMessages> tsoMessagesLst, JSONObject obj, TsoMessages tsoMessages) {
        Map tsoMessageMap = (Map)obj.get("TSO MESSAGE");
        if (tsoMessageMap != null) {
            TsoMessage tsoMessage = new TsoMessage();
            tsoMessageMap.forEach((key, value) -> {
                if ("DATA".equals(key)) {
                    tsoMessage.setData((String)value);
                }
                if ("VERSION".equals(key)) {
                    tsoMessage.setVersion((String)value);
                }
            });
            tsoMessages.setTsoMessage(tsoMessage);
            tsoMessagesLst.add(tsoMessages);
        }
    }

    private static void parseJsonTsoPrompt(List<TsoMessages> tsoMessagesLst, JSONObject obj, TsoMessages tsoMessages) {
        Map tsoPromptMap = (Map)obj.get("TSO PROMPT");
        if (tsoPromptMap != null) {
            TsoPromptMessage tsoPromptMessage = new TsoPromptMessage();
            tsoPromptMap.forEach((key, value) -> {
                if ("VERSION".equals(key)) {
                    tsoPromptMessage.setVersion((String)value);
                }
                if ("HIDDEN".equals(key)) {
                    tsoPromptMessage.setHidden((String)value);
                }
            });
            tsoMessages.setTsoPrompt(tsoPromptMessage);
            tsoMessagesLst.add(tsoMessages);
        }
    }

    private static class Holder {
        private static final TsoJsonParse instance = new TsoJsonParse();

        private Holder() {
        }
    }
}

