/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.CopyParams;

public class DsnCopy {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public DsnCopy(ZosConnection connection) {
        ValidateUtils.checkConnection(connection);
        this.connection = connection;
    }

    public DsnCopy(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkConnection(connection);
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response copy(String fromDataSetName, String toDataSetName, boolean replace, boolean copyAllMembers) throws ZosmfRequestException {
        return this.copyCommon(new CopyParams.Builder().fromDataSet(fromDataSetName).toDataSet(toDataSetName).replace(replace).copyAllMembers(copyAllMembers).build());
    }

    public Response copyCommon(CopyParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = this.setUrl(params);
        Map<String, Object> fromDataSetMap = this.setFromDataSetMapValues(params);
        HashMap<String, Object> copyMap = new HashMap<String, Object>();
        copyMap.put("request", "copy");
        copyMap.put("from-dataset", new JSONObject(fromDataSetMap));
        copyMap.put("replace", params.isReplace());
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(copyMap).toString());
        return this.request.executeRequest();
    }

    private String setUrl(CopyParams params) {
        String toDataSetNameErrMsg = "toDataSetName not specified";
        String toDataSet = params.getToDataSet().orElseThrow(() -> new IllegalArgumentException("toDataSetName not specified"));
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/";
        if (params.getToVolser().isPresent()) {
            url = url + "-(" + params.getToVolser().get() + ")/";
        }
        url = url + EncodeUtils.encodeURIComponent(toDataSet);
        return url;
    }

    private Map<String, Object> setFromDataSetMapValues(CopyParams params) {
        String fromDataSetNameErrMsg = "fromDataSetName not specified";
        String fromDataSetName = params.getFromDataSet().orElseThrow(() -> new IllegalStateException("fromDataSetName not specified"));
        HashMap<String, Object> fromDataSetReq = new HashMap<String, Object>();
        if (this.isMemberNameIncluded(fromDataSetName)) {
            int startMemberIndex = fromDataSetName.indexOf("(");
            String member = fromDataSetName.substring(startMemberIndex + 1, fromDataSetName.length() - 1);
            fromDataSetReq.put("member", member);
            fromDataSetName = fromDataSetName.substring(0, startMemberIndex);
        } else if (params.isCopyAllMembers()) {
            fromDataSetReq.put("member", "*");
        }
        fromDataSetReq.put("dsn", fromDataSetName);
        if (params.getFromVolser().isPresent()) {
            fromDataSetReq.put("volser", params.getFromVolser().get());
        }
        return fromDataSetReq;
    }

    private boolean isMemberNameIncluded(String fromDataSetName) {
        return fromDataSetName.indexOf("(") > 0;
    }
}

